/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.parser;

import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.parser.ParserException;

public class DateParser {
    private static final long[] monthOffset = new long[]{0L, 2678400000L, 5097600000L, 7776000000L, 10368000000L, 13046400000L, 15638400000L, 18316800000L, 20995200000L, 23587200000L, 26265600000L, 28857600000L};
    private static final Pattern stringPattern = Pattern.compile("(\\w{3})\\w*");
    private static final Pattern numberPattern = Pattern.compile("(\\d{1,4})");
    private static final Pattern timePattern = Pattern.compile("(\\d\\d):(\\d\\d)(:(\\d\\d))?");
    private static final Pattern timezonePattern = Pattern.compile("((\\+|-)(\\d\\d)(\\d\\d))|(\\\"?(\\w+)\\\"?)");

    private DateParser() {
    }

    private static int getMonth(String month) {
        String loweredMonth = month.toLowerCase();
        char startChar = loweredMonth.charAt(0);
        switch (startChar) {
            case 'j': {
                if (loweredMonth.equals("jan")) {
                    return 0;
                }
                if (loweredMonth.equals("jun")) {
                    return 5;
                }
                if (loweredMonth.equals("jul")) {
                    return 6;
                }
            }
            case 'f': {
                if (loweredMonth.equals("feb")) {
                    return 1;
                }
            }
            case 'm': {
                if (loweredMonth.equals("mar")) {
                    return 2;
                }
                if (loweredMonth.equals("may")) {
                    return 4;
                }
            }
            case 'a': {
                if (loweredMonth.equals("apr")) {
                    return 3;
                }
                if (loweredMonth.equals("aug")) {
                    return 7;
                }
            }
            case 's': {
                if (loweredMonth.equals("sep")) {
                    return 8;
                }
            }
            case 'o': {
                if (loweredMonth.equals("oct")) {
                    return 9;
                }
            }
            case 'n': {
                if (loweredMonth.equals("nov")) {
                    return 10;
                }
            }
            case 'd': {
                if (!loweredMonth.equals("dec")) break;
                return 11;
            }
        }
        return -1;
    }

    private static long getLeapYearCorrection(int day, int month, int year) {
        int normalizedYear = year - 1972;
        if (day <= 29 && month < 2) {
            --normalizedYear;
        }
        int leapYears = normalizedYear / 4;
        return 86400000L * (long)leapYears;
    }

    public static Date parse(CharSequence dateString) throws ParserException {
        String temp = ((Object)dateString).toString();
        Matcher matcher = stringPattern.matcher(temp);
        int month = -1;
        while (month == -1 && matcher.find()) {
            month = DateParser.getMonth(matcher.group(1));
            temp = temp.substring(0, matcher.start()) + temp.substring(matcher.end());
            matcher = stringPattern.matcher(temp);
        }
        if (month == -1) {
            throw new ParserException("Invalid Date: " + dateString);
        }
        matcher = timePattern.matcher(temp);
        if (!matcher.find()) {
            throw new ParserException("Invalid Date: " + dateString);
        }
        temp = temp.substring(0, matcher.start()) + temp.substring(matcher.end());
        int hours = Integer.parseInt(matcher.group(1));
        int minutes = Integer.parseInt(matcher.group(2));
        int seconds = 0;
        if (matcher.group(3) != null) {
            seconds = Integer.parseInt(matcher.group(4));
        }
        if (!(matcher = numberPattern.matcher(temp)).find()) {
            throw new ParserException("Invalid Date: " + dateString);
        }
        int day = Integer.parseInt(matcher.group());
        if (!(matcher = numberPattern.matcher(temp = temp.substring(0, matcher.start()) + temp.substring(matcher.end()))).find()) {
            throw new ParserException("Invalid Date: " + dateString);
        }
        int year = Integer.parseInt(matcher.group());
        if (year < 99) {
            year = year < 49 ? (year += 2000) : (year += 1900);
        }
        temp = temp.substring(0, matcher.start()) + temp.substring(matcher.end());
        long date = (long)seconds * 1000L + (long)minutes * 60000L + (long)hours * 3600000L + (long)day * 86400000L + monthOffset[month] + (long)(year - 1970) * 31536000000L + DateParser.getLeapYearCorrection(day, month, year);
        matcher = timezonePattern.matcher(temp);
        long zoneoffset = 0L;
        if (matcher.find()) {
            if (matcher.group(1) != null) {
                zoneoffset = (long)Integer.parseInt(matcher.group(4)) * 60000L + (long)Integer.parseInt(matcher.group(3)) * 3600000L;
                if (matcher.group(2).equals("+")) {
                    zoneoffset = -zoneoffset;
                }
            } else if (matcher.group(6) != null) {
                TimeZone timezone = TimeZone.getTimeZone(matcher.group(6));
                zoneoffset = timezone.getOffset(date);
            }
        }
        return new Date(date += zoneoffset);
    }
}

