/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.parser;

import java.io.IOException;
import org.columba.ristretto.io.Source;
import org.columba.ristretto.message.Header;
import org.columba.ristretto.message.LocalMimePart;
import org.columba.ristretto.message.Message;
import org.columba.ristretto.message.MimeHeader;
import org.columba.ristretto.message.MimeTree;
import org.columba.ristretto.parser.BodyParser;
import org.columba.ristretto.parser.HeaderParser;
import org.columba.ristretto.parser.ParserException;

public class MessageParser {
    private MessageParser() {
    }

    public static Message parse(Source message) throws ParserException, IOException {
        Source messageSource = message.fromActualPosition();
        Header header = HeaderParser.parse(message);
        LocalMimePart body = BodyParser.parseMimePart(new MimeHeader(header), message);
        body.setSource(messageSource);
        Message result = new Message();
        result.setHeader(header);
        result.setMimePartTree(new MimeTree(body));
        result.setSource(messageSource);
        return result;
    }
}

