/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.message.MimeType;
import org.columba.ristretto.parser.ParserException;

public class MimeTypeParser {
    private static final Pattern mimetypePattern = Pattern.compile("([^/\\s]+)/([^\\s;]+)");

    private MimeTypeParser() {
    }

    public static MimeType parse(CharSequence mimeType) throws ParserException {
        if (mimeType == null) {
            throw new ParserException("Input is null");
        }
        Matcher matcher = mimetypePattern.matcher(mimeType);
        if (matcher.find()) {
            return new MimeType(matcher.group(1).toLowerCase(), matcher.group(2).toLowerCase());
        }
        throw new ParserException();
    }
}

