/*
 * Decompiled with CFR 0.152.
 */
package org.mitre;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.BUnzip2;
import org.apache.tools.ant.taskdefs.GUnzip;
import org.apache.tools.ant.taskdefs.Untar;

public class Unpack {
    public static File gunzip(File target, String dest_dir) {
        if (!new File(dest_dir).exists()) {
            new File(dest_dir).mkdirs();
        }
        Project myProject = new Project();
        GUnzip myGunzip = new GUnzip();
        myGunzip.setProject(myProject);
        myGunzip.init();
        String destination_name = target.getName().substring(0, target.getName().length() - 3);
        File dest = new File(dest_dir, destination_name);
        myGunzip.setSrc(target);
        myGunzip.setDest(dest);
        myGunzip.execute();
        return dest;
    }

    public static File gunzip(File target) throws Exception {
        Project myProject = new Project();
        GUnzip myGunzip = new GUnzip();
        myGunzip.setProject(myProject);
        myGunzip.init();
        String destination_name = target.getName().substring(0, target.getName().length() - 3);
        File dest = new File(target.getParent(), destination_name);
        myGunzip.setSrc(target);
        myGunzip.setDest(dest);
        myGunzip.execute();
        return dest;
    }

    public static File bunzip2(File target, String dest_dir) throws Exception {
        Project myProject = new Project();
        BUnzip2 bunzip = new BUnzip2();
        bunzip.setProject(myProject);
        bunzip.init();
        File dest = new File(dest_dir);
        bunzip.setSrc(target);
        bunzip.setDest(dest);
        bunzip.execute();
        return dest;
    }

    public static File bunzip2(File target) throws Exception {
        Project myProject = new Project();
        BUnzip2 bunzip = new BUnzip2();
        bunzip.setProject(myProject);
        bunzip.init();
        String destination_name = target.getName().substring(0, target.getName().length() - 3);
        File dest = new File(target.getParent(), destination_name);
        bunzip.setSrc(target);
        bunzip.setDest(dest);
        bunzip.execute();
        return dest;
    }

    public static File unTar(File target) throws Exception {
        Project myProject = new Project();
        Untar untar = new Untar();
        untar.setProject(myProject);
        untar.init();
        String destination_name = target.getParent();
        File dest = new File(destination_name);
        untar.setSrc(target);
        untar.setDest(dest);
        untar.execute();
        target.delete();
        return dest;
    }

    public static File unZip(File target, String destination_path) throws Exception {
        int BUFFER = 4096;
        BufferedOutputStream destination = null;
        BufferedInputStream is = null;
        ZipFile zipfile = null;
        zipfile = new ZipFile(target);
        File dest = new File(destination_path);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            int count;
            String dirname;
            File dir;
            ZipEntry entry = e.nextElement();
            is = new BufferedInputStream(zipfile.getInputStream(entry));
            byte[] data = new byte[BUFFER];
            if (entry.getName().contains("/") && !(dir = new File(dest, dirname = entry.getName().substring(0, entry.getName().lastIndexOf(47)))).exists()) {
                dir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(destination_path + "/" + entry.getName());
            destination = new BufferedOutputStream(fos, BUFFER);
            while ((count = is.read(data, 0, BUFFER)) != -1) {
                destination.write(data, 0, count);
            }
            destination.flush();
            destination.close();
            is.close();
        }
        zipfile.close();
        return dest;
    }
}

