/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;

public class ImageLoading {
    protected String upload_path;
    protected Connection connection;

    public ImageLoading(String upload_path, Connection connection) {
        this.upload_path = upload_path;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write_metafile(int study_id, Session scan, Session.Image file) throws Exception {
        String meta_file = this.upload_path + "/." + file.filename + ".meta";
        PrintWriter writer = new PrintWriter(new FileOutputStream(new File(meta_file)));
        try {
            writer.println("path=" + file.path);
            writer.println("study_id=" + study_id);
            writer.println("subject_oid=" + scan.getSubject().getObject_id());
            writer.println("date=" + scan.getDate_taken());
            writer.println("scan_id=" + scan.getSession_id());
            writer.println("volume_id=" + file.volume_id);
            writer.println("scanner=" + scan.getScanner());
            writer.println("software_version=" + scan.getSoftware_version());
        }
        finally {
            writer.flush();
            writer.close();
        }
        file.metaFile = meta_file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alreadyQueued(String path) throws Exception {
        String select_sql = "SELECT ID FROM PROCESSING_Q WHERE PROCESSED=-1 AND FILE_PATH=?";
        PreparedStatement statement = this.connection.prepareStatement(select_sql);
        try {
            statement.setString(1, path);
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            statement.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue_metafile(Session.Image file) throws Exception {
        if (this.alreadyQueued(file.metaFile)) {
            return;
        }
        String insert_sql = "INSERT INTO PROCESSING_Q (FILE_PATH) VALUES (?)";
        PreparedStatement statement = this.connection.prepareStatement(insert_sql);
        try {
            statement.setString(1, file.metaFile);
            statement.execute();
        }
        finally {
            statement.close();
        }
    }

    public void queue_scans(Study study) throws Exception {
        for (Session scan : study.getSessions()) {
            for (Session.Image image : scan.getImages()) {
                if (image.missing) continue;
                this.write_metafile(study.getStudy_id(), scan, image);
                this.enqueue_metafile(image);
            }
        }
    }

    public static File find_scan(String root, String image_file) {
        File root_file = new File(root);
        if (!root_file.exists()) {
            return null;
        }
        File suspect = new File(root_file, image_file);
        if (suspect.exists()) {
            return suspect;
        }
        return null;
    }

    public boolean check_scans(Study study) throws Exception {
        boolean valid = true;
        for (Session scan : study.getSessions()) {
            for (Session.Image image : scan.getImages()) {
                File scan_file = ImageLoading.find_scan(this.upload_path, image.filename);
                if (scan_file == null) {
                    valid = false;
                    image.missing = true;
                    continue;
                }
                image.path = scan_file.getPath();
                image.filename = scan_file.getName();
            }
        }
        return valid;
    }
}

