/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.mitre.neuro.containers.Interview;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.containers.Subject;
import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.ExcelGenerator;
import org.mitre.neuro.excel.Row;
import org.mitre.neuro.excel.Worksheet;
import org.mitre.neuro.excel.biff.GenerateBIFF;
import org.mitre.neuro.excel.html.GenerateHTML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadSheetCreator {
    ExcelGenerator generator;
    Study study;

    public SpreadSheetCreator(OutputType type) throws Exception {
        switch (type) {
            case BIFF: {
                this.generator = new GenerateBIFF();
                break;
            }
            case HTML: {
                this.generator = new GenerateHTML();
            }
        }
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    protected void build_sheets() {
        this.study_sheet(this.study);
        List<Session> scans = this.study.getSessions();
        ArrayList<Subject> subjects = new ArrayList<Subject>();
        ArrayList<Session.Image> images = new ArrayList<Session.Image>();
        for (Session scan : scans) {
            Subject subject = scan.getSubject();
            subjects.add(subject);
            images.addAll(scan.getImages());
        }
        this.subject_sheet(subjects);
        this.interviews_sheet(subjects);
        this.sessionAndImagesSheets(scans);
    }

    protected void study_sheet(Study study_object) {
        Worksheet study = this.generator.addWorkSheet("Study", 0);
        Row pi = new Row(2);
        pi.addColumn(0, Datum.string("PI Name").lock());
        String investigator = study_object.getInvestigator();
        pi.addColumnEntry(1, investigator);
        study.addRow(pi);
        Row pi_email = new Row(3);
        pi_email.addColumn(0, Datum.string("PI Email Address").lock());
        String email = study_object.getPi_email();
        pi_email.addColumnEntry(1, email);
        study.addRow(pi_email);
        Row grant = new Row(4);
        grant.addColumn(0, Datum.string("Grant name").lock());
        String grant_name = study_object.getGrant_name();
        grant.addColumnEntry(1, grant_name);
        study.addRow(grant);
        Row institution = new Row(5);
        institution.addColumn(0, Datum.string("Funding Information").lock());
        String institute = study_object.getFunding_info();
        institution.addColumnEntry(1, institute);
        study.addRow(institution);
    }

    protected void subject_sheet(List<Subject> subject_list) {
        Worksheet subjects = this.generator.addWorkSheet("Subjects", 1);
        Row header = new Row(2);
        header.addColumn(0, Datum.string("Subject ID"));
        header.addColumn(1, Datum.string("Birthdate"));
        header.addColumn(2, Datum.string("Gender"));
        header.addColumn(3, Datum.string("Race"));
        header.addColumn(4, Datum.string("Education"));
        header.addColumn(5, Datum.string("Handedness"));
        header.addColumn(6, Datum.string("Height"));
        header.addColumn(7, Datum.string("Weight"));
        subjects.addRow(header);
        int row_number = 3;
        for (Subject subject : subject_list) {
            Row sub_row = new Row(row_number);
            if (subject.getSubject_id() == null) {
                Row dummy = new Row(row_number);
                for (int col = 0; col <= header.getMax(); ++col) {
                    dummy.addColumnEntry(col, "");
                }
                ++row_number;
                subjects.addRow(dummy);
                continue;
            }
            sub_row.addColumnEntry(0, subject.getSubject_id());
            sub_row.addColumnEntry(1, subject.getBirth().toString());
            sub_row.addColumnEntry(2, subject.getGender());
            sub_row.addColumnEntry(3, subject.getRace());
            sub_row.addColumnEntry(4, Integer.toString(subject.getEducation()));
            sub_row.addColumnEntry(5, subject.getHandedness());
            sub_row.addColumnEntry(6, Integer.toString(subject.getHeight()));
            sub_row.addColumnEntry(7, Integer.toString(subject.getWeight()));
            ++row_number;
            subjects.addRow(sub_row);
        }
    }

    protected void sessionAndImagesSheets(List<Session> scan_list) {
        Worksheet sessions = this.generator.addWorkSheet("Sessions", 2);
        Worksheet scans = this.generator.addWorkSheet("Sessions", 4);
        Row session_header = new Row(2);
        session_header.addColumn(0, Datum.string("Subject ID"));
        session_header.addColumn(1, Datum.string("Date"));
        session_header.addColumn(2, Datum.string("Session ID"));
        session_header.addColumn(3, Datum.string("Scanner"));
        session_header.addColumn(4, Datum.string("Location"));
        session_header.addColumn(5, Datum.string("Software Version"));
        sessions.addRow(session_header);
        Row scan_header = new Row(2);
        int i = 0;
        scan_header.addColumn(i++, Datum.string("Subject ID"));
        scan_header.addColumn(i++, Datum.string("Date"));
        scan_header.addColumn(i++, Datum.string("Session ID"));
        scan_header.addColumn(i++, Datum.string("Filename"));
        scan_header.addColumn(i++, Datum.string("Ancillary Files"));
        scan_header.addColumn(i++, Datum.string("Protocol Name"));
        scan_header.addColumn(i++, Datum.string("Modality"));
        scan_header.addColumn(i++, Datum.string("T1"));
        scan_header.addColumn(i++, Datum.string("T2"));
        scan_header.addColumn(i++, Datum.string("TR"));
        scan_header.addColumn(i++, Datum.string("TI"));
        scan_header.addColumn(i++, Datum.string("TE"));
        scan_header.addColumn(i++, Datum.string("Numercial Format"));
        scan_header.addColumn(i++, Datum.string("Excitations"));
        scan_header.addColumn(i++, Datum.string("Flip Angle"));
        scans.addRow(scan_header);
        int row_number = 3;
        int image_row = 3;
        for (Session scan : scan_list) {
            Row scan_info = new Row(row_number);
            String subject_id = scan.getSubject().getSubject_id();
            scan_info.addColumnEntry(0, subject_id);
            scan_info.addColumnEntry(1, scan.getDate_taken());
            scan_info.addColumnEntry(2, scan.getSession_id() + "");
            scan_info.addColumnEntry(3, scan.getScanner());
            scan_info.addColumnEntry(4, scan.getSoftware_version());
            sessions.addRow(scan_info);
            if (scan.getImages().size() == 0) {
                scan.addImage();
            }
            for (Session.Image image : scan.getImages()) {
                Row scan_file = new Row(image_row);
                i = 0;
                scan_file.addColumnEntry(i++, subject_id);
                scan_file.addColumnEntry(i++, "1/1/1995");
                scan_file.addColumnEntry(i++, scan.getSession_id() + "");
                scan_file.addColumnEntry(i++, image.filename);
                scan_file.addColumnEntry(i++, image.protocol_name);
                scan_file.addColumnEntry(i++, image.modality);
                scan_file.addColumnEntry(i++, image.t1);
                scan_file.addColumnEntry(i++, image.t2);
                scan_file.addColumnEntry(i++, image.tr);
                scan_file.addColumnEntry(i++, image.ti);
                scan_file.addColumnEntry(i++, image.te);
                scan_file.addColumnEntry(i++, image.num_format);
                scan_file.addColumnEntry(i++, image.excitations);
                scan_file.addColumnEntry(i++, image.flip_angle);
                scans.addRow(scan_file);
                ++image_row;
            }
            ++row_number;
        }
    }

    protected void interviews_sheet(List<Subject> subject_list) {
        Worksheet interviews = this.generator.addWorkSheet("Interviews", 3);
        Row header = new Row(2);
        header.addColumn(0, Datum.string("Subject ID"));
        header.addColumn(1, Datum.string("Interview Date"));
        header.addColumn(2, Datum.string("Session ID"));
        ArrayList<String> meta_columns = new ArrayList<String>();
        int row_number = 3;
        for (Subject subject : subject_list) {
            for (Interview interview : subject.getInterviews()) {
                Row row = new Row(row_number);
                row.addColumnEntry(0, subject.getSubject_id());
                row.addColumnEntry(1, interview.getInterview_date());
                row.addColumnEntry(2, "1");
                for (String key : interview.getKeys()) {
                    if (meta_columns.contains(key)) continue;
                    meta_columns.add(key);
                    header.addColumn(meta_columns.size() + 2, Datum.string(key));
                }
                int meta_index = 3;
                for (String key : meta_columns) {
                    row.addColumnEntry(meta_index++, interview.getMeta().get(key));
                }
                interviews.addRow(row);
                ++row_number;
            }
        }
        interviews.addRow(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate(OutputStream stream) {
        this.build_sheets();
        try {
            this.generator.getSpreadSheet(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.generator.clear();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        BIFF,
        HTML;

    }
}

