/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.database;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.database.StoreSubject;

public class StoreSession {
    Study study;
    Connection connection;
    StoreSubject subjects;

    public StoreSession(Study study, Connection connection) {
        this.study = study;
        this.connection = connection;
        this.subjects = new StoreSubject(connection);
    }

    public StoreSession(Connection connection) {
        this.connection = connection;
    }

    public void store_session_event(Session session, Session.Image image) {
        String sql = "SELECT scan_id FROM SCAN_EVENT where subject_oid = ? and project_id =?";
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setInt(1, image.subject_oid);
            if (image.study_id == Integer.MIN_VALUE) {
                statement.setInt(2, this.study.getStudy_id());
            } else {
                statement.setInt(2, image.study_id);
            }
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                image.session_id = rs.getString(1);
                session.setSession_id(image.session_id);
                System.out.println("\t\tRetrieved Scan_id: " + image.session_id);
                rs.close();
                return;
            }
            rs.close();
            sql = "INSERT INTO SCAN_EVENT (subject_oid, scan_date, project_id, scanner_id, location, software_version) VALUES (?,?,?,?,?,?)";
            statement = this.connection.prepareStatement(sql);
            statement.setInt(1, image.subject_oid);
            statement.setDate(2, new Date(System.currentTimeMillis()));
            if (image.study_id == Integer.MIN_VALUE) {
                statement.setInt(3, this.study.getStudy_id());
            } else {
                statement.setInt(3, image.study_id);
            }
            statement.setString(4, session.getScanner());
            statement.setString(5, session.getLocation());
            statement.setString(6, session.getSoftware_version());
            statement.executeUpdate();
            sql = "select last_value from scan_event_scan_id_seq";
            statement = this.connection.prepareStatement(sql);
            ResultSet generated_keys = statement.executeQuery();
            if (generated_keys.next()) {
                image.session_id = generated_keys.getString(1);
                session.setSession_id(image.session_id);
                System.out.println("\t\tStored Scan_id: " + image.session_id);
            }
            generated_keys.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
    }

    public void store_scanfile(Session.Image image) {
        String sql = "INSERT INTO IMAGES (volume_id, filename) VALUES (?,?)";
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            statement.setInt(1, Integer.parseInt(image.session_id));
            statement.setString(2, image.path);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
    }

    public void store_image(Session.Image image) {
        if (image.volume_id == Integer.MIN_VALUE) {
            String sql = "INSERT INTO VOLUME (scan_id) values (?)";
            try {
                PreparedStatement statement = this.connection.prepareStatement(sql);
                statement.setInt(1, Integer.parseInt(image.session_id));
                statement.executeUpdate();
                sql = "select last_value from volume_volume_id_seq";
                statement = this.connection.prepareStatement(sql);
                ResultSet generated_keys = statement.executeQuery();
                if (generated_keys.next()) {
                    image.volume_id = generated_keys.getInt(1);
                    System.out.println("\t\tStored Image: " + image.volume_id);
                }
                generated_keys.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return;
            }
        }
        this.updateVolume("modality", image.modality, image.volume_id);
        this.updateVolume("numerical_format", image.numerical_format, image.volume_id);
        this.updateVolume("xorientation", image.xorientation, image.volume_id);
        this.updateVolume("yorientation", image.yorientation, image.volume_id);
        this.updateVolume("zorientation", image.zorientation, image.volume_id);
        this.updateVolume("scan_id", image.session_id == null ? null : Integer.valueOf(image.session_id), image.volume_id);
        this.updateVolume("xfov", image.xfov == Double.MIN_VALUE ? null : new Double(image.xfov), image.volume_id);
        this.updateVolume("yfov", image.yfov == Double.MIN_VALUE ? null : new Double(image.yfov), image.volume_id);
        this.updateVolume("zfov", image.zfov == Double.MIN_VALUE ? null : new Double(image.zfov), image.volume_id);
        this.updateVolume("xresolution", image.xresolution == Double.MIN_VALUE ? null : new Double(image.xresolution), image.volume_id);
        this.updateVolume("yresolution", image.yresolution == Double.MIN_VALUE ? null : new Double(image.yresolution), image.volume_id);
        this.updateVolume("zresolution", image.zresolution == Double.MIN_VALUE ? null : new Double(image.zresolution), image.volume_id);
        this.updateVolume("xdimension", image.xdimension == Double.MIN_VALUE ? null : new Double(image.xdimension), image.volume_id);
        this.updateVolume("ydimension", image.ydimension == Double.MIN_VALUE ? null : new Double(image.ydimension), image.volume_id);
        this.updateVolume("zdimension", image.zdimension == Double.MIN_VALUE ? null : new Double(image.zdimension), image.volume_id);
        this.updateVolume("protocol_name", image.protocol_name, image.volume_id);
        this.updateVolume("t1", image.t1 == Double.MIN_VALUE ? null : new Double(image.t1), image.volume_id);
        this.updateVolume("t2", image.t2 == Double.MIN_VALUE ? null : new Double(image.t2), image.volume_id);
        this.updateVolume("tr", image.tr == Double.MIN_VALUE ? null : new Double(image.tr), image.volume_id);
        this.updateVolume("ti", image.ti == Double.MIN_VALUE ? null : new Double(image.ti), image.volume_id);
        this.updateVolume("te", image.te == Double.MIN_VALUE ? null : new Double(image.te), image.volume_id);
        this.updateVolume("excitations", image.excitations == Double.MIN_VALUE ? null : new Double(image.excitations), image.volume_id);
        this.updateVolume("flip_angle", image.flip_angle == Double.MIN_VALUE ? null : new Double(image.flip_angle), image.volume_id);
    }

    protected void updateVolume(String field, Object value, int vol_id) {
        if (value == null) {
            return;
        }
        try {
            String sql = "UPDATE volume set " + field + "=? where volume_id=?";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            if (value instanceof String) {
                statement.setString(1, (String)value);
                System.out.println(field + "is  String");
            } else if (value instanceof Double) {
                System.out.println(field + "is  Double");
                statement.setDouble(1, (Double)value);
            } else if (value instanceof Integer) {
                statement.setInt(1, (Integer)value);
                System.out.println(field + "is  Integer");
            }
            statement.setInt(2, vol_id);
            statement.execute();
            System.out.println("\t" + field + " updated.");
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
    }

    public void store_scan(Session scan) throws Exception {
        this.subjects.store_subject(scan.getSubject(), this.study);
        for (Session.Image i : scan.getImages()) {
            i.subject_oid = scan.getSubject().getObject_id();
            this.store_session_event(scan, i);
            this.store_image(i);
            this.store_scanfile(i);
        }
    }
}

