/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.neuro.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mitre.neuro.excel.Datum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row {
    private HashMap<Integer, Datum> columns = new HashMap();
    private int index;
    private int max;

    public Row(int row_number) {
        this.index = row_number;
        this.max = -1;
    }

    public void addColumn(int c, Datum d) {
        this.columns.put(new Integer(c), d);
        if (c > this.max) {
            this.max = c;
        }
    }

    public void addColumnEntry(int column, String entry) {
        if (entry == null || entry.length() == 0) {
            this.addColumn(column, Datum.empty());
        } else {
            this.addColumn(column, Datum.string(entry).lock());
        }
    }

    public void addColumnEntry(int column, double entry) {
        if (entry == -1.0) {
            this.addColumn(column, Datum.empty());
        } else {
            this.addColumn(column, Datum.number(entry).lock());
        }
    }

    public int getMax() {
        return this.max;
    }

    public List<Integer> getColumns() {
        return new ArrayList<Integer>(this.columns.keySet());
    }

    public Datum getColumn(int number) {
        return this.columns.get(new Integer(number));
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void clear() {
        this.columns.clear();
    }
}

