/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.composer;

import java.io.InputStream;
import java.util.Hashtable;
import org.columba.ristretto.composer.MimePartRenderer;
import org.columba.ristretto.composer.mimepartrenderers.DefaultMimePartRenderer;
import org.columba.ristretto.composer.mimepartrenderers.MultipartRenderer;
import org.columba.ristretto.composer.mimepartrenderers.TextpartRenderer;
import org.columba.ristretto.message.MimePart;
import org.columba.ristretto.message.MimeTree;
import org.columba.ristretto.message.MimeType;

public class MimeTreeRenderer {
    private Hashtable rendererMap;
    private static MimeTreeRenderer myInstance;
    private MimePartRenderer defaultRenderer = new DefaultMimePartRenderer();

    private MimeTreeRenderer() {
        this.rendererMap = new Hashtable();
        this.addMimePartRenderer(new MultipartRenderer());
        this.addMimePartRenderer(new TextpartRenderer());
    }

    public void addMimePartRenderer(MimePartRenderer renderer) {
        this.rendererMap.put(renderer.getRegisterString(), renderer);
    }

    public static MimeTreeRenderer getInstance() {
        if (myInstance == null) {
            myInstance = new MimeTreeRenderer();
        }
        return myInstance;
    }

    public InputStream renderMimeTree(MimeTree tree) throws Exception {
        return this.renderMimePart(tree.getRootMimeNode());
    }

    public InputStream renderMimePart(MimePart part) throws Exception {
        MimePartRenderer renderer = this.getRenderer(part.getHeader().getMimeType());
        return renderer.render(part);
    }

    private MimePartRenderer getRenderer(MimeType type) {
        if (type == null) {
            return this.defaultRenderer;
        }
        MimePartRenderer renderer = (MimePartRenderer)this.rendererMap.get(type.toString());
        if (renderer != null) {
            return renderer;
        }
        renderer = (MimePartRenderer)this.rendererMap.get(type.getType());
        if (renderer != null) {
            return renderer;
        }
        return this.defaultRenderer;
    }
}

