/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.composer.mimepartrenderers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.columba.ristretto.composer.MimePartRenderer;
import org.columba.ristretto.composer.MimeTreeRenderer;
import org.columba.ristretto.io.SequenceInputStream;
import org.columba.ristretto.message.MimeHeader;
import org.columba.ristretto.message.MimePart;
import org.columba.ristretto.message.StreamableMimePart;

public class MultipartRenderer
extends MimePartRenderer {
    public String getRegisterString() {
        return "multipart";
    }

    public InputStream render(MimePart part) throws Exception {
        Vector<InputStream> streams = new Vector<InputStream>(part.countChilds() * 2 + 3);
        MimeHeader header = part.getHeader();
        String boundary = ((Object)this.createUniqueBoundary()).toString();
        header.putContentParameter("boundary", boundary);
        byte[] startBoundary = ("\r\n--" + boundary + "\r\n").getBytes();
        byte[] endBoundary = ("\r\n--" + boundary + "--\r\n").getBytes();
        streams.add(header.getHeader().getInputStream());
        if (part instanceof StreamableMimePart) {
            streams.add(((StreamableMimePart)part).getInputStream());
        }
        for (int i = 0; i < part.countChilds(); ++i) {
            streams.add(new ByteArrayInputStream(startBoundary));
            streams.add(MimeTreeRenderer.getInstance().renderMimePart(part.getChild(i)));
        }
        streams.add(new ByteArrayInputStream(endBoundary));
        return new SequenceInputStream(streams);
    }
}

