/*
 *  Copyright (C) 2007 The MITRE Corporation.  All rights reserved.
 *
 *  MRALD is released under the license specified in the file
 *  mrald_license.txt supplied with this file.  If you cannot find this
 *  file, contact The MITRE Technology Transfer Office at techtransfer@mitre.org
 *  or at http://www.mitre.org/work/tech_transfer/
 */

package org.mitre.mrald.chart;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.*;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.data.category.*;
import org.mitre.mrald.util.*;

import de.laures.cewolf.links.CategoryItemLinkGenerator;
import de.laures.cewolf.ChartPostProcessor;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.DatasetProducer;
/**
 *  An example data producer.
 *
 *@author     Gail Hamilton
 *@created    December 20, 2004
 */
public class ChartData implements DatasetProducer, CategoryItemLinkGenerator, CategoryToolTipGenerator, Serializable, ChartPostProcessor
{

	private final static Log log = LogFactory.getLog(ChartData.class);

	// These values would normally not be hard coded but produced by
	// some kind of data source like a database or a file
	private List categories= new ArrayList();
	private List seriesNames = new ArrayList();

	private String query = "";

	public void processChart(Object chart, Map params) {
		CategoryPlot plot = (CategoryPlot) ((JFreeChart) chart).getPlot();

        CategoryAxis axis = (CategoryAxis) plot.getDomainAxis();
        //jch - line above was:
		//HorizontalCategoryAxis axis = (HorizontalCategoryAxis) plot.getDomainAxis();

		Number rotateThreshold = (Number) params.get("rotate_at");
		Number skipThreshold = (Number) params.get("skip_at");
		Number removeThreshold = (Number) params.get("remove_at");

		CategoryDataset dataset = plot.getDataset(); //jch - changed from: plot.getCategoryDataset();
		int iCategoryCount = dataset.getRowCount();

        //jch - removed code below in move to new version
		/* if (rotateThreshold != null) {
			axis.setVerticalCategoryLabels(iCategoryCount >= rotateThreshold.intValue());
		}
		if (skipThreshold != null) {
			axis.setSkipCategoryLabelsToFit(iCategoryCount >= skipThreshold.intValue());
		} */
		if (removeThreshold != null) {
			axis.setTickLabelsVisible(iCategoryCount < removeThreshold.intValue());
		}
	}

	/**
	 *  Produces some random data.
	 *
	 *@param  params                       Description of the Parameter
	 *@return                              Description of the Return Value
	 *@exception  DatasetProduceException  Description of the Exception
	 */
	public Object produceDataset(Map params) throws DatasetProduceException
	{
		try
		{
			int labelLimit = 0;
			int rowCount = 100000;
			int startCount = 0;

			log.debug("producing data.");
			if (params.containsKey("query"))
			{
				query = (String) params.get("query");
			}
			if (params.containsKey("labelLimit"))
			{
				labelLimit = new Integer (params.get("labelLimit").toString() ).intValue();
				if (labelLimit < 0) labelLimit = 0;
			}
			if (params.containsKey("rowCount"))
			{
				rowCount = new Integer (params.get("rowCount").toString() ).intValue();

			}
			if (params.containsKey("startCount"))
			{
				startCount = new Integer (params.get("startCount").toString() ).intValue();

			}
			DefaultCategoryDataset dataset =
				new DefaultCategoryDataset()
				{
					/**
					 *@exception  Throwable  Description of the Exception
					 *@see                   java.lang.Object#finalize()
					 */
					protected void finalize() throws Throwable
					{
						super.finalize();
						log.debug(this + " finalized.");
					}
				};

			MraldConnection conn = new MraldConnection(Config.getProperty("DBSERVER"), Config.getProperty("DBDRIVER"), Config.getProperty("DBLOGIN"), Config.getProperty("DBPASSWORD"));
			ResultSet rs;

			rs = conn.executeQuery(query);
			String columnName = "";
			boolean firstTime = true;
			boolean thirdColumn = false;
			int count = 0;
			while (rs.next() && count < rowCount)
			{
				count++;
				if (startCount > count) continue;

				if (firstTime)
				{
					ResultSetMetaData rsmd = rs.getMetaData();
					if (rsmd.getColumnCount() > 2)
					{
						thirdColumn = true;
					} else
					{
						columnName = rsmd.getColumnName(1);
					}
					firstTime=false;
				}

				if (thirdColumn)
				{
					//dataset.addValue(new Integer(rs.getString(2)), rs.getString(1), "test");

					String label = rs.getString(2);
					String label2 = rs.getString(3);
					if (label == null)
						label="null";

					if (labelLimit < label.length())
						label= label.substring(0, labelLimit);

					if (label2 == null)
						label2 = "null";
					dataset.addValue(new Float(rs.getString(1)), label2, label);
					seriesNames.add(label + " value=" + new Float(rs.getString(1)) );
					if (!categories.contains(label2))
					       categories.add(label2);
				} else
				{
					String label = rs.getString(2);
					if (label == null)
						label="null";

					if (labelLimit < label.length())
						label= label.substring(0, labelLimit);
					dataset.addValue(new Float(rs.getString(1)), columnName, "'"  + label + "'");
					seriesNames.add(label + " value=" + new Float(rs.getString(1)) );

					if (!categories.contains(label))
					       categories.add(label);
				}

			}
			rs.close();
			conn.close();
			return dataset;
		} catch (Exception e)
		{
			throw new DatasetProduceException(e.getMessage());
		}
	}


	/**
	 *  This producer's data is invalidated after 5 seconds. By this method the
	 *  producer can influence Cewolf's caching behaviour the way it wants to.
	 *
	 *@param  params  Description of the Parameter
	 *@param  since   Description of the Parameter
	 *@return         Description of the Return Value
	 */
	public boolean hasExpired(Map params, Date since)
	{
		log.debug(getClass().getName() + "hasExpired()");
		return (System.currentTimeMillis() - since.getTime()) > 5000;
	}


	/**
	 *  Returns a unique ID for this DatasetProducer
	 *
	 *@return    The producerId value
	 */
	public String getProducerId()
	{
		return "PageViewCountData DatasetProducer";
	}


	/**
	 *  Returns a unique ID for this DatasetProducer
	 *
	 *@param  query  The new query value
	 */
	public void setQuery(String query)
	{

		this.query = query;

	}


	/**
	 *  Returns a unique ID for this DatasetProducer
	 *
	 *@return    The query value
	 */
	public String getQuery()
	{

		return query;
	}


	/**
	 *  Returns a link target for a special data item.
	 *
	 *@param  data      Description of the Parameter
	 *@param  series    Description of the Parameter
	 *@param  category  Description of the Parameter
	 *@return           Description of the Return Value
	 */
	public String generateLink(Object data, int series, Object category)
	{
		//return seriesNames.get(series).toString();
		if (series > (categories.size()-1) )
			return "no data";
	        return categories.get(series).toString();
	}


	/**
	 *@exception  Throwable  Description of the Exception
	 *@see                   java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable
	{
		super.finalize();
		log.debug(this + " finalized.");
	}


	/**
	 *@param  arg0    Description of the Parameter
	 *@param  series  Description of the Parameter
	 *@param  arg2    Description of the Parameter
	 *@return         Description of the Return Value
	 *@see            org.jfree.chart.tooltips.CategoryToolTipGenerator#generateToolTip(CategoryDataset,
	 *      int, int)
	 */
	public String generateToolTip(CategoryDataset arg0, int series, int arg2)
	{
		if (arg2 > (seriesNames.size()-1) )
			return "no data";
		return seriesNames.get(arg2).toString();
	}

}

