#!/bin/sh
#
# handy functions:
#
# a function to display a failure message and then exit

backup_dir=/home/neuroweb/backup_uploads
exclude="root neuroweb atlas"
targetuser=$1
#set argument to NO for no backup
backup=${2:-"backup"}

fail ( ) {
	echo "error: $@"
	exit 1
}

# "get with default" function
# this function prompts the user with a query and default reply
# it returns the user reply
getwd ( ) {
	query="$1"
	default="$2"
	echo -en "$query [$default]" | cat >&2
	read response
	if [ x$response = "x" ]; then
		response=$default
	fi
	echo $response
}
# we need to be root
if [ `/usr/bin/id -u` != "0" ]; then
	fail "you must be root to run this script\n"
fi

for name in $exclude; do
        if [ "$targetusr" = $name ] ; then
                fail "this user cannot be deleted this way.."
        fi
done;

username_collision=`id $targetuser > /dev/null 2> /dev/null; echo $?`
if [ $username_collision -ne 0 ] ; then
        fail "the user $targetuser doesnt exist"
fi

userdel $targetuser
if [ $? -ne 0 ] ; then
        fail "could not delete $targetuser"
fi

if [ "backup" = "$backup" ] ; then
   if [ -d $backup_dir/$targetuser ] ; then
        rm -rf $backup_dir/$targetuser
   fi
   mkdir $backup_dir/$targetuser
   mv /home/$targetuser/uploads $backup_dir/$targetuser
   if [ $? -eq 0 ] ; then
        chown -R neuroweb $backup_dir/$targetuser
        echo "Your data has been retained, and can be recovered. "
        echo "Please let us know if you are done and we can reclaim the space. "
   else
        fail "could not backup your upload directory. Please tell us about this problem"
   fi

else
   echo "_NO_ backup has been made for $targetuser";
fi
rm -rf /home/$targetuser

echo "user $targetuser removed."
exit 0;
