#!/bin/bash

total=`pgrep poll_q.sh | wc -l`
if [ $total -gt 2 ] ; then
     echo "img_proc already running"
     exit 127;
fi

max_process=10

current_marker="select last_value from PROCESS_MARKER"

marker=`psql -d neuroweb -c "$current_marker" -t -A`

echo "marker at $marker..."

get_images="select id from processing_q where processed=-1 and id>=$marker"
id_list=`psql -d neuroweb -c "$get_images" -t -A`

last_id=$marker

for id in $id_list ; do
        last_id=`expr $id + 1`
        /usr/bin/time --quiet --output .timing -f %e ./process_img.sh $id #&>/dev/null
        if [ $? -ne 0 ] ; then
                echo "image processing failed for $id"
                continue;
        fi

        timing=`cat .timing`
        timing=`echo "$timing" / 1 | bc`
        rm .timing

        psql -d neuroweb -c "update processing_q set processed=$timing where id=$id" > /dev/null
        echo -n ".";
done

if [ $marker -ne $last_id ] ; then
        echo "setting savepoint..."
        psql -d neuroweb -c "select setval('process_marker', $last_id)" > /dev/null
else
        echo "Nothing queued."
fi

echo "done."
