#!/bin/bash
if [ ! $ATLAS_HOME ] ; then
    source environ.source
fi
MAIN=org.mitre.neuro.Upload 

BIN=$ATLAS_HOME/bin
process=$ATLAS_HOME/data

if [ ! -d $process ]; then 
    exit 0;
fi

echo "
processing $process for data...
"
CLASSPATH=$BIN:`cat $ATLAS_HOME/.classpath_cache`
echo "
using classpath: $CLASSPATH
"

echo "
compiling...
"
$BIN/atlas_compile
if [ $? -ne 0 ] ; then
    exit 127;
fi

JAVA=$JAVA_HOME/bin/java
echo "
using java: $JAVA
running: $MAIN
"

exec $JAVA -cp $CLASSPATH $MAIN $process
