package org.mitre.neuro;

import java.io.OutputStream;
import java.sql.Connection;
import java.util.List;

import org.mitre.neuro.SpreadSheetCreator.OutputType;
import org.mitre.neuro.containers.Interview;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.containers.Subject;
import org.mitre.neuro.database.StoreStudy;

/**
 * Give it a connection, project, and pi, then set up any EAV attributes
 * Generate a spreadsheet against the output stream supplied to generate
 * function
 */
public class GenerateUpload {

	Connection connection;
	Study study;

	public static int BLANKS=100;

	public GenerateUpload(Connection connection, String project_name) {
        System.out.println( "in GenerateUpload constructor" );
		this.connection = connection;
		this.study = new Study();
		if(project_name != null ){
			study.setGrant_name(project_name);
			// study.setInvestigator(PI);
            boolean loaded = false;
			try {
				loaded = StoreStudy.get_study(connection, study);
			} catch (Exception e) {
				e.printStackTrace();
			}
            if( !loaded )
            {
                System.out.println( "WARNING!!  Could not load study " + project_name );
            }
		}

	}

	public void setAttributes(List<String> entity_list){
		Interview interview = new Interview();
		for (String key : entity_list){
			interview.addValue(key, "");
		}

	    //add at least one new row to make sure the entities columns get written out
		int generate_rows = study.getSessions().size() > 0 ?
												1 : BLANKS;

		Subject subject = new Subject();
		subject.addInterview(interview);

		for (int i=0;i<generate_rows; i++){
			Session scan = new Session();
			scan.setSubject(subject);
			study.addSession(scan);
		}
	}

	/**
	 *
	 * output's a binary xls file against the output stream
	 *
	 * Set # of blanks to zero or the number of highlighted rows to
	 * generate
	 *
	 * If a study has been set up, the meta-data already stored
	 * will appear as well.
	 *
	 */
	public void generate(OutputStream out){
		try {
			SpreadSheetCreator creator = new SpreadSheetCreator(OutputType.BIFF);
			creator.setStudy(study);
			creator.generate(out);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
