/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Interview {
	String interview_date;

	/**
	 * This includes everything from stroop test information
	 * and moodscale data
	 * to customized meta-data collected
	 */
	List<String> keys;
	HashMap<String, String> meta;

	public Interview(){
		this.meta = new HashMap<String, String>();
		this.keys = new ArrayList<String>();
	}

	public void addValue(String key, String value){
		this.meta.put(key, value);
		this.keys.add(key);
	}

	public String getValue(String key){
		return this.meta.get(key);
	}

	public HashMap<String, String> getMeta() {
		return meta;
	}

	public void clearMeta() {
		this.meta = new HashMap<String, String>();
		this.keys = new ArrayList<String>();
	}

	public List<String> getKeys() {
		return keys;
	}

	public void setKeys(List<String> keys) {
		this.keys = keys;
	}

	public String getInterview_date() {
		return interview_date;
	}

	public void setInterview_date(String interview_date) {
		this.interview_date = interview_date;
	}
}
