/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.containers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Subject {
	List<Interview> interviews;

	//natural key given a particular study(project)
	String subject_id;

	//surrogate key for a unique subject object (primary key)
	int object_id;

	Date initial_exam;
	Date birth;
	String nationality;
	String gender;
	String race;
	String primary_language;
	String secondary_language;
	String marital_status;
	int education = Integer.MIN_VALUE;
	String handedness;
	int height = Integer.MIN_VALUE;
	int weight = Integer.MIN_VALUE;

	public Subject(){
		this.interviews = new ArrayList<Interview>();
	}
	public Subject(String subject_id){
		this();
		this.subject_id = subject_id;
	}

	public String getSubject_id() {
		return subject_id;
	}

	public void setSubject_id(String subject_id) {
		this.subject_id = subject_id;
	}

	public void addInterview(Interview interview){
		this.interviews.add(interview);
	}

	public List<Interview> getInterviews(){
		return this.interviews;
	}
	public int getObject_id() {
		return object_id;
	}
	public void setObject_id(int object_id) {
		this.object_id = object_id;
	}
	public Date getInitial_exam() {
		return initial_exam;
	}
	public void setInitial_exam(Date initial_exam) {
		this.initial_exam = initial_exam;
	}
	public Date getBirth() {
		return birth;
	}
	public void setBirth(Date birth) {
		this.birth = birth;
	}
	public String getNationality() {
		return nationality;
	}
	public void setNationality(String nationality) {
		this.nationality = nationality;
	}
	public String getGender() {
		return gender;
	}
	public void setGender(String gender) {
		this.gender = gender;
	}
	public String getRace() {
		return race;
	}
	public void setRace(String race) {
		this.race = race;
	}
	public String getPrimary_language() {
		return primary_language;
	}
	public void setPrimary_language(String primary_language) {
		this.primary_language = primary_language;
	}
	public String getSecondary_language() {
		return secondary_language;
	}
	public void setSecondary_language(String secondary_language) {
		this.secondary_language = secondary_language;
	}
	public String getMarital_status() {
		return marital_status;
	}
	public void setMarital_status(String marital_status) {
		this.marital_status = marital_status;
	}
	public int getEducation() {
		return education;
	}
	public void setEducation(int education) {
		this.education = education;
	}
	public String getHandedness() {
		return handedness;
	}
	public void setHandedness(String handedness) {
		this.handedness = handedness;
	}
	public int getHeight() {
		return height;
	}
	public void setHeight(int height) {
		this.height = height;
	}
	public int getWeight() {
		return weight;
	}
	public void setWeight(int weight) {
		this.weight = weight;
	}
	public void setInterviews(List<Interview> interviews) {
		this.interviews = interviews;
	}
}
