/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

import org.mitre.neuro.containers.Interview;
import org.mitre.neuro.containers.Subject;

public class StoreInterview {
	Connection connection;
	Subject subject;

	public StoreInterview(Connection connection, Subject subject){
		this.connection = connection;
		this.subject = subject;
	}
	public int getEntityId(String entity_name) throws Exception{
		String sql = "SELECT ENTITY_ID FROM ENTITY WHERE NAME=?";
		int id=-1;
		PreparedStatement statement = this.connection.prepareStatement(sql);
		try {
			statement.setString(1, entity_name);
			ResultSet result = statement.executeQuery();
			if(result.next()){
				id = result.getInt(1);
			}
		}
		finally {
			statement.close();
		}
		return id;
	}
	/**
	 * The attr id is used as a foreign key by the
	 * values table
	 * @return
	 */
	public int getAttributeId(String entity_name, String attribute_name)throws Exception{
		int entity_id=this.getEntityId(entity_name);
		String sql = "SELECT ATTRIBUTE_ID FROM ATTRIBUTE WHERE ENTITY_ID=? AND" +
				" NAME=?";
		int id=-1;
		PreparedStatement statement = this.connection.prepareStatement(sql);
		try {
			statement.setInt(1, entity_id);
			statement.setString(2, attribute_name);
			ResultSet result = statement.executeQuery();
			if(result.next()){
				id = result.getInt(1);
			}
		}
		finally {
			statement.close();
		}
		return id;
	}
	/**
	 * Adds value to the appropriate
	 * @param entity
	 * @param attribute
	 */
	public void add_value(String entity, String attribute, String value) throws Exception{
		int parent = this.getAttributeId(entity, attribute);
		if(parent == -1){
			throw new Exception ("There is no entity attribute pair " + entity + ":" + attribute);
		}
		String sql = "INSERT INTO SUBJECT_VALUES (DATE, VALUE, ATTRIBUTE_ID, SUBJECT_OID) " +
				"VALUES (?,?,?,?)";
		PreparedStatement statement = this.connection.prepareStatement(sql);
		try{
			statement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
			statement.setString(2, value);
			statement.setInt(3, parent);
			statement.setInt(4, this.subject.getObject_id());
			statement.execute();
		}
		finally {
			statement.close();
		}
	}

	public void store_interview(Interview interview) throws Exception{
		//System.out.println("Storing interview...");
		for (String key : interview.getKeys()){
			String value = interview.getValue(key);
            // System.out.println( key + ":" + value );
			String []composite = key.split(":");
			String entity = composite[0];
			String attribute = composite[1];
			add_value(entity, attribute, value);
		}
	}
}
