/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.demo;

import java.io.File;
import java.io.FileOutputStream;

import org.mitre.neuro.SpreadSheetCreator;
import org.mitre.neuro.SpreadSheetCreator.OutputType;
import org.mitre.neuro.containers.Interview;
import org.mitre.neuro.containers.Session;
import org.mitre.neuro.containers.Study;
import org.mitre.neuro.containers.Subject;

public class DemoSpreadSheetCreator {

	public static final int BLANKS=64;

	public static void main(String [] args){

		/*
		 * Set up anything we already know and
		 * provide space for new entries
		 */

		Study study = new Study();
		Interview interview =  new Interview();
		interview.addValue("Stroop Correct", "");
		interview.addValue("Stroop Time", "");
		interview.addValue("MoodScale/Anxious", "");
		interview.addValue("MoodScale/Relaxed", "");
		Subject subject = new Subject();
		subject.addInterview(interview);
		for(int i =0; i < BLANKS; i++){ //generate 64 blank fields
			Session scan = new Session();
			scan.setSubject(subject);
			study.addSession(scan);
		}
		study.setPi_email("esax@mitre.org");
		study.setInvestigator("Erik");
		study.setFunding_info("MITRE");
		study.setGrant_name("fun");

		/*
		 * Output both types of spreadsheets,
		 * std out allows easy testing
		 */
		try {

			//SpreadSheetCreator html_maker = new SpreadSheetCreator(Output.HTML);
			//html_maker.setStudy(study);
			//html_maker.generate(System.out);

			SpreadSheetCreator biff_maker = new SpreadSheetCreator(OutputType.BIFF);
			biff_maker.setStudy(study);
			FileOutputStream os =  new FileOutputStream(new File("demo.xls"));
			biff_maker.generate(os);
			os.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}