/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 *
 */
package org.mitre.neuro.excel.biff;

import java.io.OutputStream;
import java.util.Arrays;

import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.ExcelGenerator;
import org.mitre.neuro.excel.Row;
import org.mitre.neuro.excel.Worksheet;

/**
 * @author esax
 */
public class GenerateBIFF extends ExcelGenerator {

	WritableCellFormat locked_cell;
	WritableCellFormat fillable_cell;

	public GenerateBIFF() throws Exception{
		super();
		this.locked_cell = new WritableCellFormat();
		this.locked_cell.setBackground(Colour.GRAY_25);
		this.locked_cell.setLocked(true);
		this.locked_cell.setBorder(Border.ALL, BorderLineStyle.THIN);
		this.fillable_cell = new WritableCellFormat();
		this.fillable_cell.setBackground(Colour.VERY_LIGHT_YELLOW);
		this.fillable_cell.setBorder(Border.ALL, BorderLineStyle.THIN);

	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.mitre.neuro.excel.ExcelGenerator#getSpreadSheet()
	 */
	@Override
	public void getSpreadSheet(OutputStream stream) throws Exception {
		WritableWorkbook workbook = Workbook.createWorkbook(stream);
		Integer [] sheet_numbers = new Integer[this.worksheets.keySet().size()];
		this.worksheets.keySet().toArray(sheet_numbers);
		Arrays.sort(sheet_numbers);
		for (Integer number : sheet_numbers) {
			Worksheet sheet = this.worksheets.get(number);
			WritableSheet sheetwriter = workbook.createSheet(sheet.getName(), number);
			//sheetwriter.setProtected(true);
			this.writeSheet(sheetwriter, sheet);
		}
		workbook.write();
		workbook.close(); //this does not close the stream
	}

	/*
	 * Implimentation specifics
	 */

	/**
	 * Each row of data is written out for a given worksheet
	 */
	protected void writeSheet(WritableSheet writer, Worksheet sheet)
			throws Exception {
		for (Row row : sheet.getRows()) {
			for (Integer column_index : row.getColumns()) {
				Datum d = row.getColumn(column_index);
				int y = row.getIndex();
				int x = column_index;
				WritableCell cell = this.getCell(x, y, d);
				if (cell == null) {
					System.err.println("bad cell defined for (" + x + ", " + y + ")");
					continue;
				}
				writer.addCell(cell);
			}
		}
	}

	protected WritableCell getCell(int x, int y, Datum d){
		//TODO: dates and formulae
		switch(d.getT()){
		case STRING:
			return new Label(x, y, d.getString_dat(), this.locked_cell);
		case NUMBER:
			return new jxl.write.Number(x, y, d.getNumber_dat());
		case EMPTY:
			return new Label(x, y, "", this.fillable_cell);
		default:
			return null;
		}
	}

}
