/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuro.excel.html;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;

import org.mitre.neuro.excel.Datum;
import org.mitre.neuro.excel.ExcelGenerator;
import org.mitre.neuro.excel.Row;
import org.mitre.neuro.excel.Worksheet;

/**
 * This class is mostly here to help with testing and debugging
 * (imagine excel or open office firing up every time you want to test
 * this via the web...)
 *
 * plus if you call it a .xls and set the content type to
 * application/vnd.ms-excel then excel or open office will see it
 * as a regular spreadsheet, and the user can save it however they want
 *
 * It just won't be multisheet
 *
 * @author esax
 */
public class GenerateHTML extends ExcelGenerator {

	@Override
	public void getSpreadSheet(OutputStream stream) throws Exception {
		PrintWriter writer = new PrintWriter(stream);
		Integer [] sheet_numbers = new Integer[this.worksheets.keySet().size()];
		this.worksheets.keySet().toArray(sheet_numbers);
		Arrays.sort(sheet_numbers);
		for (Integer number : sheet_numbers) {
			Worksheet sheet = this.worksheets.get(number);
			writer.println("<h2>" + sheet.getName() + "</h2>");
			this.printSheet(writer, sheet);
		}
		writer.flush();
	}

	protected void printSheet(PrintWriter printer, Worksheet sheet){
		printer.println("<table>");
		for(int i =0; i < sheet.getSize(); i++){
				Row row = sheet.getOrAddRow(i);
				this.printRow(printer, row);
		}
		printer.println("</table>");
	}

	protected void printRow(PrintWriter printer, Row row){
		printer.println("\t<tr>");
		Integer [] columns = new Integer[row.getColumns().size()];
		row.getColumns().toArray(columns);
		Arrays.sort(columns);
		int next = 0;
		for(Integer index : columns){
			if(index != next){
				for(;next<index;next++){
					printer.println("\t\t<td></td>");
				}
			}
			next++;
			Datum d = row.getColumn(index);
			this.printCell(printer, d);
		}
		printer.println("\t</tr>");
	}

	protected void printCell(PrintWriter printer, Datum d){
		printer.println("\t\t<td>");
		printer.print("\t\t\t");
		this.print_data(printer, d);
		printer.println("\t\t</td>");
	}

	protected void print_data(PrintWriter printer, Datum d){
		if(d.getT() == Datum.Type.STRING){
			printer.println(d.getString_dat());
		}
		if(d.getT() == Datum.Type.EMPTY){
			printer.println();
		}
		if(d.getT() == Datum.Type.NUMBER){
			printer.println(d.getNumber_dat());
		}
		if(d.getT() == Datum.Type.FORMULA){
			printer.println("Formula: " + d.getFormula());
		}

	}
}
