/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.*;
import java.io.*;
import java.sql.*;


/**
 *  This file
 */
public class BuildInterview
{
    private String query =
        "select subject_id, e.name, a.name, value "+
        "from subject_values s natural join attribute a join entity e on (e.entity_id = a.entity_id) " +
        "where subject_id like '%UT%' order by subject_id, e.name, a.name;";
    private Properties info = new Properties();
    private String COMMA = ",";

    public static void main (String[] args)
    throws Exception
    {
        BuildInterview doer = new BuildInterview();
        if( args.length != 1 )
        {
            System.out.println( "usage: java BuildInterview <db config file> " );
            System.exit(10);
        }
        doer.getInfo(args[0]);
    }

    public void getInfo(String config)
    throws Exception
    {
        info.load(new FileReader(config));
        Class.forName( info.getProperty("driver"));
        Connection conn = DriverManager.getConnection(info.getProperty("server"), info);
        //get a reference to the statement
        PreparedStatement s = conn.prepareStatement( query );
        // s.setString( 1, filename );
        ResultSet rs = s.executeQuery();
        String volumeId = null;
        ResultSetMetaData md = rs.getMetaData();
        int count = md.getColumnCount();

        /* print MNI the header */
        // System.out.println( "Subject ID,Attention Deficit Disorder,Attention Deficit Disorder,Attention Deficit Disorder,Balance,Balance,Balance,Brain Tumor,Brain Tumor,Brain Tumor,Cancer,Cancer,Cancer,CHOICE_RT,CHOICE_RT,CHOICE_RT,CHOICE_RT,CHOICE_RT,Color Blindness,Color Blindness,Color Blindness,Dizziness,Dizziness,Dizziness,Epilepsy,Epilepsy,Epilepsy,Finger Tapping,Finger Tapping,Handedness,Handedness,Handedness,Handedness,Handedness,Handedness,Handedness,Handedness,Handedness,Handedness,Handedness,Handedness,Handedness,Headache,Headache,Headache,Head Injury,Head Injury,Head Injury,Hearing,Hearing,Hearing,Hyperactivity,Hyperactivity,Hyperactivity,Hypertension,Hypertension,Hypertension,Last Menstrual Period,Last Menstrual Period,Last Menstrual Period,Last_Period_Duration,Last_Period_Duration,Last_Period_Duration,Memory,Memory,Memory,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,MOODSCALE,Other Drugs,Other Drugs,Other Drugs,Past MRI Date,Past MRI Date,Past MRI Date,Past PET Date,Past PET Date,Past PET Date,Past Surgery,Past Surgery,Past Surgery,Reading,Reading,Reading,REVERSE_RT,REVERSE_RT,REVERSE_RT,REVERSE_RT,REVERSE_RT,SAME_OPPOSITE,SAME_OPPOSITE,Schizophrenia,Schizophrenia,Schizophrenia,Seizure,Seizure,Seizure,SIMPLE_RT,SIMPLE_RT,SIMPLE_RT,SIMPLE_RT,Speech,Speech,Speech,Stroke,Stroke,Stroke,STROOP,STROOP,STROOP_2,STROOP_2,STROOP_3,Syncope,Syncope,Syncope,Touch,Touch,Touch,Verbal Recent Memory,Verbal Recent Memory,Verbal Recent Memory,Verbal Recent Memory,Vision,Vision,Vision,Visual Recent Memory,Visual Recent Memory,Visual Recent Memory,Visual Recent Memory,VS_PRO,VS_PRO,VS_PRO,VS_PRO,VS_PRO,VS_PRO,WEAKNESS,WEAKNESS,WEAKNESS" );
        // System.out.println( "Subject ID,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,AVERAGE,ERRORS,LEFT,RIGHT,STDEV,comments,current,ever,comments,current,ever,comments,current,ever,LEFT,RIGHT,AVERAGE_HANDED,DRAWING,EYE,FOOT,HAMMER,KEY,MATCH,SCISSORS,SCREWDRIVER,SPOON,THROWING,TOOTHBRUSH,WRITING,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,ANXIOUS_NOW,ANXIOUS_TENSE,CALM,CAREFREE,CLEAR_HEADED,CONFIDENT,CONFUSED,DEPRESSED_SAD,DISCOURAGED,ENERGETIC,ENTHUSIASTIC,FEARFUL,HAPPY,IRRITABLE,RELAXED,RESTLESS,SATISFIED,SLEEP_LAST_NIGHT,SLEEP_TYPICAL,SUSPICIOUS,TIRED,TOT_NEGATIVE,TOT_POSITIVE,TRUSTING,WORRIED,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,AVERAGE,ERRORS,LEFT,RIGHT,STDEV,CORRECT,TIME,comments,current,ever,comments,current,ever,AVERAGE,LEFT,RIGHT,STDEV,comments,current,ever,comments,current,ever,CORRECT,TIME,CORRECT,TIME,TIME,comments,current,ever,comments,current,ever,ALARM,HITS,MISSES,REJECT,comments,current,ever,ALARM,HITS,MISSES,REJECT,ALARM,CNR,HITS,MISSES,STIMULI,THROUGHPUT,comments,current,ever" );

        /* print the UT header */
        System.out.println( "Subject Id,ABSTRACT_TOT, ABSTRACT_TOT, ABSTRACT_TOT, Alcohol, Alcohol, Alcohol, Anxiety, Anxiety, Anxiety, Attention Deficit Disorder, Attention Deficit Disorder, Attention Deficit Disorder, Balance, Balance, Balance, BALANCE_RHOMBERG, BALANCE_RHOMBERG, Blood Pressure, Blood Pressure, BRAIN_DISEASE, BRAIN_DISEASE, BRAIN_DISEASE, Brain Tumor, Brain Tumor, Brain Tumor, BULK, BULK, Cancer, Cancer, Cancer, CHOICE_RT, CHOICE_RT, CHOICE_RT, CHOICE_RT, CHOICE_RT, CHOICE_RT, Color Blindness, Color Blindness, Color Blindness, Contact Lens, Contact Lens, CORRECT_ABSTRACT, CORRECT_ABSTRACT, CORRECT_ABSTRACT, CPT_BOX, CPT_BOX, CPT_BOX, CPT_BOX, CPT_BOX, CPT_BOX, CPT_BOX, CPT_BOX, CPT_BOX, CPT_BOX, CPTBOX2, CPTBOX2, CPTBOX2, CPTBOX2, CPTBOX2, CPTBOX2, CPTBOX2, CRANIAL_NERVES, CRANIAL_NERVES, Depression, Depression, Depression, Diabetes, Diabetes, Diabetes, Dizziness, Dizziness, Dizziness, DRUGS, DRUGS, DRUGS, Epilepsy, Epilepsy, Epilepsy, Extremities, Extremities, Finger Tapping, Finger Tapping, Gait, Gait, Glasses, Glasses, Graphesthesia, Graphesthesia, Handedness, Handedness, Handedness, Handedness, Handedness, Handedness, Handedness, Handedness, Handedness, Handedness, Handedness, Handedness, Handedness, Headache, Headache, Headache, Head Injury, Head Injury, Head Injury, Hearing, Hearing, Hearing, HEART, HEART, HEART, HEART, Heart Rate, Heart Rate, Height, Height, HIGH_BLOOD_PRESSURE, HIGH_BLOOD_PRESSURE, HIGH_BLOOD_PRESSURE, Hyperactivity, Hyperactivity, Hyperactivity, Hypertension, Hypertension, Hypertension, Involuntary Movements, Involuntary Movements, Last Menstrual Period, Last Menstrual Period, Last Menstrual Period, Last_Period_Duration, Last_Period_Duration, Last_Period_Duration, LUNGS, LUNGS, Memory, Memory, Memory, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, MOODSCALE, Movement, Movement, Movement, Muscle Tone, Muscle Tone, Operation, Operation, Operation, Other, Other, Other, OTHER_DISEASE, OTHER_DISEASE, OTHER_DISEASE, Other Drugs, Other Drugs, Other Drugs, OTHER_PYSCH, OTHER_PYSCH, OTHER_PYSCH, Pain, Pain, Past MRI, Past MRI, Past MRI, Past MRI Date, Past MRI Date, Past MRI Date, Past PET, Past PET, Past PET, Past PET Date, Past PET Date, Past PET Date, Past Surgery, Past Surgery, Past Surgery, Pathologic Reflex, Pathologic Reflex, Position, Position, RAPID_ALTERNATING, RAPID_ALTERNATING, Reading, Reading, Reading, REVERSE_RT, REVERSE_RT, REVERSE_RT, REVERSE_RT, REVERSE_RT, REVERSE_RT, SAME_OPPOSITE, SAME_OPPOSITE, Schizophrenia, Schizophrenia, Schizophrenia, Seizure, Seizure, Seizure, SIMPLE_RT, SIMPLE_RT, SIMPLE_RT, SIMPLE_RT, SIMPLE_RT, Speech, Speech, Speech, STANCE, STANCE, Stereognosis, Stereognosis, Strength, Strength, Stroke, Stroke, Stroke, STROOP, STROOP, STROOP_2, STROOP_2, STROOP_3, STROOP_3, Syncope, Syncope, Syncope, Temperature, Temperature, Tendon Reflex, Tendon Reflex, Touch, Touch, Touch, Touch, Verbal Recent Memory, Verbal Recent Memory, Verbal Recent Memory, Verbal Recent Memory, Vibration, Vibration, Vision, Vision, Vision, Visual Recent Memory, Visual Recent Memory, Visual Recent Memory, Visual Recent Memory, VRBMEMDELAY, VRBMEMDELAY, VRBMEMDELAY, VRBMEMDELAY, VRBMEMDELAY, VRBMEMDELAY, VRBMEMDELAY, VRBMEMDELAY, VRBMEMDELAY, VS_PRO, VS_PRO, VS_PRO, VS_PRO, VS_PRO, VS_PRO, WEAKNESS, WEAKNESS, WEAKNESS, Weight, Weight,," );
        System.out.println( "Subject Id,CORR,FAIL,PRES,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,normalcy,comments,normalcy,comments,current,ever,comments,current,ever,comments,normalcy,comments,current,ever,AVERAGE,ERRORS,LEFT,MEDIAN,RIGHT,STDEV,comments,current,ever,comments,normalcy,SET1,SET2,SET3,ACCURACY,BIAS,CORR_REJ,DELAYED,FALSE,F_HALF,HIT,MISS,S_HALF,TOT_CORR,ACCURACY,BIAS,CORRECTIONS_REJECTIONS,FALSE_ALARMS,HITS,MISSES,TOTAL_CORRECT,comments,normalcy,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,normalcy,LEFT,RIGHT,comments,normalcy,comments,normalcy,comments,normalcy,AVERAGE_HANDED,DRAWING,EYE,FOOT,HAMMER,KEY,MATCH,SCISSORS,SCREWDRIVER,SPOON,THROWING,TOOTHBRUSH,WRITING,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,normalcy,comments,normalcy,comments,normalcy,comments,current,ever,comments,current,ever,comments,current,ever,comments,normalcy,comments,current,ever,comments,current,ever,comments,normalcy,comments,current,ever,ANXIOUS_NOW,ANXIOUS_TENSE,CALM,CAREFREE,CLEAR_HEADED,CONFIDENT,CONFUSED,DEPRESSED_NOW,DEPRESSED_SAD,DISCOURAGED,ENERGETIC,ENTHUSIASTIC,FEARFUL,HAPPY,IRRITABLE,RELAXED,RESTLESS,SATISFIED,SLEEP_LAST_NIGHT,SLEEP_TYPICAL,SUSPICIOUS,TIRED,TOT_NEGATIVE,TOT_POSITIVE,TRUSTING,WORRIED,comments,current,ever,comments,normalcy,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,normalcy,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,current,ever,comments,normalcy,comments,normalcy,comments,normalcy,comments,current,ever,AVERAGE,ERRORS,LEFT,MEDIAN,RIGHT,STDEV,CORRECT,TIME,comments,current,ever,comments,current,ever,AVERAGE,LEFT,MEDIAN,RIGHT,STDEV,comments,current,ever,comments,normalcy,comments,normalcy,comments,normalcy,comments,current,ever,CORRECT,TIME,CORRECT,TIME,CORRECT,TIME,comments,current,ever,comments,normalcy,comments,normalcy,comments,current,ever,normalcy,ALARM,HITS,MISSES,REJECT,comments,normalcy,comments,current,ever,ALARM,HITS,MISSES,REJECT,ACCURACY,BIAS,CORRECTIONS_REJECTIONS,FALSE_ALARM_RATE,FALSE_ALARMS,HIT_RATE,HITS,MISSES,TOTAL_CORRECT,ALARM,CNR,HITS,MISSES,STIMULI,THROUGHPUT,comments,current,ever,comments,normalcy" );

        /* UT attributes */
        String[] entities = { "ABSTRACT_TOT","ABSTRACT_TOT","ABSTRACT_TOT","Alcohol","Alcohol","Alcohol","Anxiety","Anxiety","Anxiety","Attention Deficit Disorder","Attention Deficit Disorder","Attention Deficit Disorder","Balance","Balance","Balance","BALANCE_RHOMBERG","BALANCE_RHOMBERG","Blood Pressure","Blood Pressure","BRAIN_DISEASE","BRAIN_DISEASE","BRAIN_DISEASE","Brain Tumor","Brain Tumor","Brain Tumor","BULK","BULK","Cancer","Cancer","Cancer","CHOICE_RT","CHOICE_RT","CHOICE_RT","CHOICE_RT","CHOICE_RT","CHOICE_RT","Color Blindness","Color Blindness","Color Blindness","Contact Lens","Contact Lens","CORRECT_ABSTRACT","CORRECT_ABSTRACT","CORRECT_ABSTRACT","CPT_BOX","CPT_BOX","CPT_BOX","CPT_BOX","CPT_BOX","CPT_BOX","CPT_BOX","CPT_BOX","CPT_BOX","CPT_BOX","CPTBOX2","CPTBOX2","CPTBOX2","CPTBOX2","CPTBOX2","CPTBOX2","CPTBOX2","CRANIAL_NERVES","CRANIAL_NERVES","Depression","Depression","Depression","Diabetes","Diabetes","Diabetes","Dizziness","Dizziness","Dizziness","DRUGS","DRUGS","DRUGS","Epilepsy","Epilepsy","Epilepsy","Extremities","Extremities","Finger Tapping","Finger Tapping","Gait","Gait","Glasses","Glasses","Graphesthesia","Graphesthesia","Handedness","Handedness","Handedness","Handedness","Handedness","Handedness","Handedness","Handedness","Handedness","Handedness","Handedness","Handedness","Handedness","Headache","Headache","Headache","Head Injury","Head Injury","Head Injury","Hearing","Hearing","Hearing","HEART","HEART","HEART","HEART","Heart Rate","Heart Rate","Height","Height","HIGH_BLOOD_PRESSURE","HIGH_BLOOD_PRESSURE","HIGH_BLOOD_PRESSURE","Hyperactivity","Hyperactivity","Hyperactivity","Hypertension","Hypertension","Hypertension","Involuntary Movements","Involuntary Movements","Last Menstrual Period","Last Menstrual Period","Last Menstrual Period","Last_Period_Duration","Last_Period_Duration","Last_Period_Duration","LUNGS","LUNGS","Memory","Memory","Memory","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","MOODSCALE","Movement","Movement","Movement","Muscle Tone","Muscle Tone","Operation","Operation","Operation","Other","Other","Other","OTHER_DISEASE","OTHER_DISEASE","OTHER_DISEASE","Other Drugs","Other Drugs","Other Drugs","OTHER_PYSCH","OTHER_PYSCH","OTHER_PYSCH","Pain","Pain","Past MRI","Past MRI","Past MRI","Past MRI Date","Past MRI Date","Past MRI Date","Past PET","Past PET","Past PET","Past PET Date","Past PET Date","Past PET Date","Past Surgery","Past Surgery","Past Surgery","Pathologic Reflex","Pathologic Reflex","Position","Position","RAPID_ALTERNATING","RAPID_ALTERNATING","Reading","Reading","Reading","REVERSE_RT","REVERSE_RT","REVERSE_RT","REVERSE_RT","REVERSE_RT","REVERSE_RT","SAME_OPPOSITE","SAME_OPPOSITE","Schizophrenia","Schizophrenia","Schizophrenia","Seizure","Seizure","Seizure","SIMPLE_RT","SIMPLE_RT","SIMPLE_RT","SIMPLE_RT","SIMPLE_RT","Speech","Speech","Speech","STANCE","STANCE","Stereognosis","Stereognosis","Strength","Strength","Stroke","Stroke","Stroke","STROOP","STROOP","STROOP_2","STROOP_2","STROOP_3","STROOP_3","Syncope","Syncope","Syncope","Temperature","Temperature","Tendon Reflex","Tendon Reflex","Touch","Touch","Touch","Touch","Verbal Recent Memory","Verbal Recent Memory","Verbal Recent Memory","Verbal Recent Memory","Vibration","Vibration","Vision","Vision","Vision","Visual Recent Memory","Visual Recent Memory","Visual Recent Memory","Visual Recent Memory","VRBMEMDELAY","VRBMEMDELAY","VRBMEMDELAY","VRBMEMDELAY","VRBMEMDELAY","VRBMEMDELAY","VRBMEMDELAY","VRBMEMDELAY","VRBMEMDELAY","VS_PRO","VS_PRO","VS_PRO","VS_PRO","VS_PRO","VS_PRO","WEAKNESS","WEAKNESS","WEAKNESS","Weight","Weight" };
        String[] attributes = {"CORR","FAIL","PRES","comments","current","ever","comments","current","ever","comments","current","ever","comments","current","ever","comments","normalcy","comments","normalcy","comments","current","ever","comments","current","ever","comments","normalcy","comments","current","ever","AVERAGE","ERRORS","LEFT","MEDIAN","RIGHT","STDEV","comments","current","ever","comments","normalcy","SET1","SET2","SET3","ACCURACY","BIAS","CORR_REJ","DELAYED","FALSE","F_HALF","HIT","MISS","S_HALF","TOT_CORR","ACCURACY","BIAS","CORRECTIONS_REJECTIONS","FALSE_ALARMS","HITS","MISSES","TOTAL_CORRECT","comments","normalcy","comments","current","ever","comments","current","ever","comments","current","ever","comments","current","ever","comments","current","ever","comments","normalcy","LEFT","RIGHT","comments","normalcy","comments","normalcy","comments","normalcy","AVERAGE_HANDED","DRAWING","EYE","FOOT","HAMMER","KEY","MATCH","SCISSORS","SCREWDRIVER","SPOON","THROWING","TOOTHBRUSH","WRITING","comments","current","ever","comments","current","ever","comments","current","ever","comments","current","ever","normalcy","comments","normalcy","comments","normalcy","comments","current","ever","comments","current","ever","comments","current","ever","comments","normalcy","comments","current","ever","comments","current","ever","comments","normalcy","comments","current","ever","ANXIOUS_NOW","ANXIOUS_TENSE","CALM","CAREFREE","CLEAR_HEADED","CONFIDENT","CONFUSED","DEPRESSED_NOW","DEPRESSED_SAD","DISCOURAGED","ENERGETIC","ENTHUSIASTIC","FEARFUL","HAPPY","IRRITABLE","RELAXED","RESTLESS","SATISFIED","SLEEP_LAST_NIGHT","SLEEP_TYPICAL","SUSPICIOUS","TIRED","TOT_NEGATIVE","TOT_POSITIVE","TRUSTING","WORRIED","comments","current","ever","comments","normalcy","comments","current","ever","comments","current","ever","comments","current","ever","comments","current","ever","comments","current","ever","comments","normalcy","comments","current","ever","comments","current","ever","comments","current","ever","comments","current","ever","comments","current","ever","comments","normalcy","comments","normalcy","comments","normalcy","comments","current","ever","AVERAGE","ERRORS","LEFT","MEDIAN","RIGHT","STDEV","CORRECT","TIME","comments","current","ever","comments","current","ever","AVERAGE","LEFT","MEDIAN","RIGHT","STDEV","comments","current","ever","comments","normalcy","comments","normalcy","comments","normalcy","comments","current","ever","CORRECT","TIME","CORRECT","TIME","CORRECT","TIME","comments","current","ever","comments","normalcy","comments","normalcy","comments","current","ever","normalcy","ALARM","HITS","MISSES","REJECT","comments","normalcy","comments","current","ever","ALARM","HITS","MISSES","REJECT","ACCURACY","BIAS","CORRECTIONS_REJECTIONS","FALSE_ALARM_RATE","FALSE_ALARMS","HIT_RATE","HITS","MISSES","TOTAL_CORRECT","ALARM","CNR","HITS","MISSES","STIMULI","THROUGHPUT","comments","current","ever","comments","normalcy" };

        // System.err.println( entities.length + "|" + attributes.length );

        String lastSubj = "";
        int col = 0;
        while(rs.next())
        {
            String subj = rs.getString(1);
            if( subj.equals(lastSubj ) )
            {
                while( !rs.getString(2).equals(entities[col]) || !rs.getString(3).equals(attributes[col]))
                {
                    // System.out.println( rs.getString(2)+"."+rs.getString(3) + "|" + entities[col]+"."+attributes[col] );
                    System.out.print( COMMA );
                    col++;
                }
                System.out.print( rs.getString( 4 ) + COMMA );
                    // System.out.println( rs.getString(2)+"."+rs.getString(3) + "|" + entities[col]+"."+attributes[col] );
                col++;
            }
            else
            {
                System.out.print( "\n" + rs.getString( 1 ) + COMMA );
                lastSubj = subj;
                col=0;
            }
            // String name = md.getColumnName( i + 1 );
            // String value = rs.getString( i + 1 );
        }
    }
}
