<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="../ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.Config" %>
<html>
  <head>
  	<%@include file='title.html'%>
</head>
<body>
<div id="wrap">
<%@include file='pageHeader.jsp'%>
    <mrald:validate />
<script type="text/javascript">
function Enable(objElement)
    {
    objElement.disabled = false;
    objElement.value = '1';
    }
    function Disable(objElement)
    {
    objElement.disabled = true;
    objElement.value = '0';
    }

  function addVolumeID()
  {
    document.submittingForm.InsertVolume1.value += "~Value:" + document.submittingForm.VolumeID.value;
    document.submittingForm.SuccessUrl.value += "?VolumeID=" + document.submittingForm.VolumeID.value;
    document.submittingForm.SuccessUrl.value += "&amp;fileName=" + document.submittingForm.fileName.value;
    document.submittingForm.submit();
  }

</script>

<script language="JavaScript1.2" type="text/javascript" src="../CalendarPopup.js">
</script>
    <script language="JavaScript1.2" type="text/javascript" src="checkPkValue.js"></script>
<script language="JavaScript1.2" type="text/javascript" src="checkField.js">
</script>

<div id="content">

<h2><strong> Insert Derived <span class="gray">Image</span></strong></h2>

   	<br/><br/>

    <form enctype="x-www-form-urlencoded" action="FormSubmit" method="POST" name="submittingForm" onSubmit="if (checkForm(this.VolumeID, 'Volume ID' ) &amp;&amp; checkForm(this.MultiSelect1[1], 'Source Image(s)' ) &amp;&amp; checkForm(this.InsertAlgorithm1[1], 'Algorithm Identification' ) &amp;&amp; checkForm(this.fileName, 'Save File As' )) addVolumeID(); else return false;">
      <input name="Schema" type="hidden" value="public" />
      <input name="form" type="hidden" value="Insert Derived Image" />
      <input value="Building Multi DDL" name="workflow" type="hidden" />
      <input value="InsertDerivedImageDestination.jsp" name="SuccessUrl" type="hidden" />
      <input value="failedInsert.jsp" name="FailureUrl" type="hidden" />
      <center>
      <h2><strong>Volume Information<span class="gray"> Data</span></strong></h2>

        <table summary="" width="100%" border="0" cellspacing="1" cellpadding="2">

                      <tr>
                        <td align="right" width="50%">Volume ID:
                        <font color="#FF0000">*</font>
                        </td>
                        <td align="left">
                          <input type="hidden" name="InsertVolume1" value="Table:volume~Field:volume_id~Order:2~Type:String~SqlThread:3,4" />
                          <input type="text" length="50" name="VolumeID" />
                        </td>
                      </tr>
                      <tr>
                        <td align="right" width="50%">File Type:</td>
                        <td align="left">
                          <input type="hidden" name="InsertVolume2" value="Table:volume~Field:state~Order:3~Type:String~SqlThread:3" />
                          <select name="InsertVolume2">
                            <option value="Registered">Registered</option>
                            <option value="Skull Stripped">Skull Stripped</option>
                            <option value="Tissue Classified">Tissue Classified</option>
                            <option value="Registered (Intra-subject)">Registered (Intra-subject)</option>
                            <option value="Registered (Inter-subject)">Registered (Inter-subject)</option>
                            <option value="Tensor Map">Tensor Map</option>
                            <option value="RA Map">RA Map</option>
                            <option value="FA Map">FA Map</option>
                            <option value="VC Map">VC Map</option>
                          </select>
                        </td>
                      </tr>
                    </table>

		    <br/>
		     <h2><strong>Source <span class="gray"> Image(s)</span><font color="#FF0000">*</font></strong></h2>

                    <table summary="" width="100%" border="0" cellspacing="1" cellpadding="2">

                      <tr>
                        <td VALIGN="center" align="center">Please select the source image(s) for your derived images from the list below. To select MORE than one images, hold the Control ('CTRL') key when selecting any image. To de-select any of the selected images, simply hold the Control ('CTRL') key and click on the image. All images below are loaded from the database. To upload another source image, please use the
                        <a href="uploadImage.jsp">Image Upload Utility</a>
                        .
                        <br />
                        <br />
                        <input type="hidden" name="MultiSelect1" value="Table:derivation_history~Field:source_volume_id~Type:String~Order:1~SqlThread:4" />
                        <select multiple="multiple" size="8" name="MultiSelect1">
                          <lattice:latticeDropDownList datasource="main" table="volume" listColumn="volume_id" pkColumn="volume_id" />
                        </select>
                        </td>
                      </tr>
                    </table>

		     <br/>
		     <h2><strong>Deriving <span class="gray"> Algorithm </span></strong></h2>

                    <table summary="" width="100%" border="0" cellspacing="1" cellpadding="2">

                      <tr>
                        <td align="right" width="50%">Algorithm Identification:
                        <font color="#FF0000">*</font>
                        </td>
                        <td align="left">
                          <input type="hidden" name="InsertAlgorithm1" value="Table:algorithm~Field:algorithm_id~Order:3~Type:String~SqlThread:1,3" />
                          <input type="text" length="30" name="InsertAlgorithm1" />
                        </td>
                      </tr>
                      <tr>
                        <td align="right" width="50%">Name:</td>
                        <td align="left">
                          <input type="hidden" name="InsertAlgorithm2" value="Table:algorithm~Field:name~Order:2~Type:String~SqlThread:1" />
                          <input type="text" length="30" name="InsertAlgorithm2" />
                        </td>
                      </tr>
                      <tr>
                        <td align="right" width="50%">Version:</td>
                        <td align="left">
                          <input type="hidden" name="InsertAlgorithm3" value="Table:algorithm~Field:version~Order:3~Type:String~SqlThread:1" />
                          <input type="text" length="30" name="InsertAlgorithm3" />
                        </td>
                      </tr>
                      <tr>
                        <td align="right" width="50%">Description:</td>
                        <td align="left">
                          <input type="hidden" name="InsertAlgorithm4" value="Table:algorithm~Field:description~Order:4~Type:String~SqlThread:1" />
                          <input type="text" length="30" name="InsertAlgorithm4" />
                        </td>
                      </tr>
                    </table>

		    <br/>
		     <h2><strong>Upload <span class="gray"> Image </span></strong></h2>

                    <table summary="" width="100%" border="0" cellspacing="1" cellpadding="2">

                      <tr>
                        <td valign="center" align="center" colspan="2">The majority of the information necessary to upload a derived image is captured below. The final step, identifying the file to be uploaded, will be done in the succeeding pages.</td>
                      </tr>
                      <tr>
                        <td valign="center" align="right" width="50%">Save Image File as:
                        <font color="#FF0000">*</font>
                        </td>
                        <td align="left" width="50%">
                          <input type="text" length="50" name="fileName" />
                          <br />
                        </td>
                      </tr>
                    </table>

                    <div align="center">
                          <input type="submit" style="background:#396db9;color:white;"  value="Load Derived Image" />
                          <input type="reset" style="background:#4088b8;color:#c8c8c8;" value="Reset Form" />
                          <br />
                          <br />
                        </div>

          <center>
            <lattice:showCOI />
          </center>

    </form>
     <br/>
       <h2></h2>
    </div>
    <%@include file='menus.jsp'%>
  </body>
</html>

