<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="../ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.*" %>
<%@ page import="org.mitre.mrald.util.User" %>
<%@ page import="org.mitre.mrald.util.Config" %>
<%@ page import="org.mitre.neuro.Scponly" %>
<%@ page import="java.io.File" %>
<mrald:validate />
<%
    String study   = WebUtils.getOptionalParameter(request, "study");
    String restore = WebUtils.getOptionalParameter(request, "restore");
    String username =request.getParameter("username");

    if(username == null){
        User mraldUser = (User)session.getAttribute(Config.getProperty("cookietag"));
        username = mraldUser.getEmail();
        username = username.substring(0, username.indexOf('@'));
    }
    if(username.equals("admin") || username.equals("atlas")){
        username = "atlas-admin";
    }

%>

<html>
  <head>
        <%@include file='title.html'%>
</head>
    <body>
    <div id="wrap">
        <%@include file='pageHeader.jsp'%>

        <div id="content">
<%
    if (Scponly.userExists(username)) {
        out.println(username +" already has an account on this system.");
        return;
    }

    if (restore == "" && new File("/home/neuroweb/backup_uploads/" + username).exists()) {%>
         <h2><strong>A backup of your last upload account has been saved, <span class="gray"><%=username%></span></strong></h2>
<br>
                <ul>
                        <li><a href="addFtp.jsp?restore=true">Restore from backup</a></li>
                        <li><a href="addFtp.jsp?restore=false">_DO NOT_ restore from backup</a></li>
                </ul>
   <% }
    else {%>
         <h2><strong> Adding upload account for <span class="gray"><%=username%></span></strong></h2>
<%

        String pass = Scponly.makeUserPassword(username);
        if(pass == null){%>

            <br>Failed to generate a password
            <br>Contact an administrator for help

        <%}
        else{%>
            <br>Username: <%=username%>
            <br>password: <%=pass%>

            <br>
            <br>
            <br>

<%          for(String line : Scponly.adduser(username, pass, Boolean.parseBoolean(restore))){ %>

                 <br> <%=line%>

<%          }
        }
    }
%>


        </div>
        <%@include file='menus.jsp'%>  <%-- includes close for wrap <div> --%>
  </body>
</html>

