<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ page errorPage="ErrorHandler.jsp" %>
<%-- <%@ taglib prefix="tags" tagdir="/WEB-INF/tags" %> --%>
<%@ page import="org.mitre.mrald.util.*,java.io.*" %>
<mrald:validate />
<jsp:useBean id="cart" scope="session" class="org.mitre.neuroWeb.ImageCart" />
<jsp:setProperty name="cart" property="*" />
<%
    User mraldUser = (User)session.getAttribute(Config.getProperty("cookietag"));
    String username = mraldUser.getEmail();
    username = username.substring(0, username.indexOf('@'));
    if(username.equals("admin") || username.equals("atlas")){
        username = "atlas-admin";
    }
    Object[] images = cart.getImages();
    String source;
    File target = new File ("/home/" + username + "/uploads/downloads");
    String error = null;
    if( !target.exists() )
    {
        System.out.println( target + " does not exist." );
        try
        {
            target.mkdir();
        }
        catch(SecurityException e)
        {
            error = "Could not create a download directory.  Report this to the system administrator.";
            System.out.println( error );
        }
    }
    if( error == null )
    {
        for(int i = 0; i < images.length; i++)
        {
            source = String.valueOf(images[i]);

            Runtime rt=Runtime.getRuntime();
            Process result=null;
	    String filename = (String)images[i];
            String exe=new String("ln -s " + source + " " + target.getAbsolutePath() + File.separator + filename.substring(filename.lastIndexOf(File.separator) + 1));
            System.out.print( "running: " + exe );
            result=rt.exec(exe);
            result.waitFor();
            System.out.println( " ==> Result: " + result.exitValue() );
        }
    }
%>

<html>
    <head>
        <%@include file='title.html'%>
    </head>
    <body>
        <div id="wrap">
            <%@include file='pageHeader.jsp'%>
            <div id="content">
                <br/>
                <%
                    if( error != null )
                    {
                        %>
                            Your download area has been created using your upload account password.  This area will be shut down in one week.
                        <%
                    }
                    else
                    {
                        out.write( error );
                    }
                %>

            </div>
            <%@include file='menus.jsp'%>
        <%-- menu.jsp includes close for wrap <div> --%>
    </body>
</html>



