<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="../ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.Config" %>
<%@ page import="org.mitre.mrald.util.WebUtils" %>
<html>



<%
    pageContext.setAttribute( "pageurl", "insert_mri_volume_scan.jsp", pageContext.SESSION_SCOPE );
    String scanner_id=WebUtils.getOptionalAttribute(pageContext,"scanner_id" , pageContext.SESSION_SCOPE);
    String modality=WebUtils.getOptionalAttribute(pageContext,"modality" , pageContext.SESSION_SCOPE );
    String numerical_format= WebUtils.getOptionalAttribute(pageContext,"numerical_format" , pageContext.SESSION_SCOPE);
    String file_format=WebUtils.getOptionalAttribute(pageContext,"file_format" , pageContext.SESSION_SCOPE );
    String state=WebUtils.getOptionalAttribute(pageContext,"state" , pageContext.SESSION_SCOPE );
    String scan_location= WebUtils.getOptionalAttribute(pageContext,"scan_location" , pageContext.SESSION_SCOPE );
    String scan_date=WebUtils.getOptionalAttribute(pageContext,"scan_date" , pageContext.SESSION_SCOPE );
    String grant_no= WebUtils.getOptionalAttribute(pageContext,"grant_no" , pageContext.SESSION_SCOPE);
    String tr= WebUtils.getOptionalAttribute(pageContext,"tr" , pageContext.SESSION_SCOPE);
    String te= WebUtils.getOptionalAttribute(pageContext,"te" , pageContext.SESSION_SCOPE);
    String sequence= WebUtils.getOptionalAttribute(pageContext,"sequence" , pageContext.SESSION_SCOPE);
    String sw_version= WebUtils.getOptionalAttribute(pageContext,"software_version" , pageContext.SESSION_SCOPE);
    String excitations= WebUtils.getOptionalAttribute(pageContext,"excitations" , pageContext.SESSION_SCOPE);
    String thickness= WebUtils.getOptionalAttribute(pageContext,"thickness" , pageContext.SESSION_SCOPE);
    String xorientation= WebUtils.getOptionalAttribute(pageContext,"xorientation" , pageContext.SESSION_SCOPE);
    String yorientation= WebUtils.getOptionalAttribute(pageContext,"yorientation" , pageContext.SESSION_SCOPE);
    String zorientation= WebUtils.getOptionalAttribute(pageContext,"zorientation" , pageContext.SESSION_SCOPE);
    String xdimension= WebUtils.getOptionalAttribute(pageContext,"xdimension" , pageContext.SESSION_SCOPE);
    String ydimension= WebUtils.getOptionalAttribute(pageContext,"ydimension" , pageContext.SESSION_SCOPE);
    String zdimension= WebUtils.getOptionalAttribute(pageContext,"zdimension" , pageContext.SESSION_SCOPE);
    String xresolution= WebUtils.getOptionalAttribute(pageContext,"xRes" , pageContext.SESSION_SCOPE);
    String yresolution= WebUtils.getOptionalAttribute(pageContext,"yRes" , pageContext.SESSION_SCOPE);
    String zresolution= WebUtils.getOptionalAttribute(pageContext,"zRes" , pageContext.SESSION_SCOPE);
    String xfov= WebUtils.getOptionalAttribute(pageContext,"xfov" , pageContext.SESSION_SCOPE);
    String yfov= WebUtils.getOptionalAttribute(pageContext,"yfov" , pageContext.SESSION_SCOPE);
    String zfov= WebUtils.getOptionalAttribute(pageContext,"zfov" , pageContext.SESSION_SCOPE);
    String xtime= WebUtils.getOptionalAttribute(pageContext,"xtime" , pageContext.SESSION_SCOPE);
    String ytime= WebUtils.getOptionalAttribute(pageContext,"ytime" , pageContext.SESSION_SCOPE);
    String ztime= WebUtils.getOptionalAttribute(pageContext,"ztime" , pageContext.SESSION_SCOPE);

    pageContext.removeAttribute("scanner_id", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("modality", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("file_format", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("state", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("numerical_format", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("scan_location", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("scan_date", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("grant_no", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("tr", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("te", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("sequence", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("software_version", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("excitations", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("thickness", pageContext.SESSION_SCOPE);

    pageContext.removeAttribute("xorientation", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("yorientation", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("zorientation", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("xdimension", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("ydimension", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("zdimension", pageContext.SESSION_SCOPE);

    pageContext.removeAttribute("xRes", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("yRes", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("zRes", pageContext.SESSION_SCOPE);

    pageContext.removeAttribute("xfov", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("yfov", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("zfov", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("xtime", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("ytime", pageContext.SESSION_SCOPE);
    pageContext.removeAttribute("ztime", pageContext.SESSION_SCOPE);
%>

 <head>
  	<%@include file='title.html'%>
</head>
<body>
<div id="wrap">
<%@include file='pageHeader.jsp'%>
    <mrald:validate />
<script type="text/javascript">
function Enable(objElement)
    {
    objElement.disabled = false;
    objElement.value = '1';
    }
    function Disable(objElement)
    {
    objElement.disabled = true;
    objElement.value = '0';
    }

    function setSuccessUrl(thisForm)
    {
    	if (!checkForm(thisForm.Insert2[0], 'Subject ID' ))
            return false;
        if (!checkForm(thisForm.Insert30[0], 'Volume ID' ))
            return false;
        if (!checkForm(thisForm.Insert15[0], 'Subject Age' ))
            return false;
        if (!checkForm(thisForm.Insert11[0], 'Scan Date' ))
            return false;
    }
</script>
<script language="JavaScript1.2" type="text/javascript" src="../CalendarPopup.js">
</script>
    <script language="JavaScript1.2" type="text/javascript" src="checkPkValue.js"></script>
<script language="JavaScript1.2" type="text/javascript" src="checkField.js">
</script>

<div id="content">
      <h2><strong> Input Aquisition <span class="gray">Parameters</span></strong></h2>

      <form enctype="x-www-form-urlencoded" action="insert_default_mri_scan_event.jsp" name="FormRetrieve" method="POST">

            <table cellpadding="2" cellspacing="1" border="0" width="100%" summary="">
              <tr>
			    <td colspan="4"><center><H2>&nbsp;<b>s el e c t&nbsp;  p r o t o c o l&nbsp; n a m e</b></H2></center></td>
				<tr>
				</tr>
					<td>
					<div align="center">

					<select name="protocol_name" length="30" ><option selected="true" value="" ></option><mrald:dropDownList datasource="main" table='scan_protocol' listColumn='scan_protocol_name' pkColumn='scan_protocol_name'/></select>

					<input value="Set Data" style="background:#396db9;color:white;" type="submit"><br>
					</div>
				</td>
			  </tr>
            </table>
      </form>

      <form enctype="x-www-form-urlencoded" action="FormSubmit" name="FormInsert" method="POST"  onSubmit="return setSuccessUrl(this)">
        <input name="Schema" type="hidden" value="public"><input name="form" type="hidden" value="Scan Event"><input value="Building Multi DDL" name="workflow" type="hidden">
        <input value="uploadImage.jsp" name="SuccessUrl" type="hidden"><input value="failedInsert.jsp" name="FailureUrl" type="hidden"><input name="outputFormat21" type="hidden" value="fieldname:scan_id~nicename:scan_id~type:Numeric"><input name="outputFormat22" type="hidden" value="fieldname:subject_id~nicename:subject_id~type:String"><input name="outputFormat23" type="hidden" value="fieldname:scanner_id~nicename:scanner_id~type:String"><input name="outputFormat24" type="hidden" value="fieldname:grant_no~nicename:grant_no~type:String"><input name="outputFormat25" type="hidden" value="fieldname:modality~nicename:modality~type:String"><input name="outputFormat26" type="hidden" value="fieldname:sequence~nicename:sequence~type:String">

                    <input type="hidden" value="Datasource:main~Table:!All~SequenceTable:scan_event~Field:scan_id~Order:1~Type:Numeric~SqlThread:-1" name="Sequence1">
                    <table cellpadding="2" cellspacing="1" border="0" width="100%" summary="">
						<tr>
						 <td colspan="4"><center><H2>&nbsp;<b>a q u i s i t i o n&nbsp;  p a r a m e t e r s &nbsp;</b></H2></center></td>
						</tr>
						<tr>
                         <td>
                          <b>Subject ID: <font  color="#FF0000">*</font></b>
                         </td>
                         <td colspan="3">
                          <select name="Insert2"><option></option><lattice:latticeDropDownList datasource="main" table='subject' listColumn='subject_id' pkColumn='subject_id'/>
                          </select><input type="hidden" value="Table:scan_event~Field:subject_id~Order:2~Type:String~SqlThread:1" name="Insert2"><br>
                         </td>
						</tr>
                       <tr>
                        <td>
                          <b>Volume ID:<font  color="#FF0000">*</font></b>
                        </td>
                        <td colspan="3">
							<input type="text" length="30" name="Insert30"  onchange="checkPkExists('volume','volume_id', this.value, 'Volume ID')">
							<input type="hidden" value="Table:volume~Field:volume_id~Order:2~Type:String~SqlThread:3" name="Insert30">
                            <br>
                        </td>
                      </tr>
                     <tr>
                        <td>
                          <b>Subject Age:<font  color="#FF0000">*</font></b>
                        </td>
                        <td colspan="3">
							<input type="text" value="" name="Insert15"> (e.g., 14.5, 14y 6m)<br>
							<input type="hidden" value="Table:scan_event~Field:subject_age~Order:15~Type:String~SqlThread:1" name="Insert15">
                          </td>
                      </tr>
					  <tr>
                        <td>
                          <b>Scan Date:<font  color="#FF0000">*</font></b>
                        </td>
                        <td colspan="3">
                          <input type="text" length="30" name="Insert11">
							<script type="text/javascript" language="JavaScript">
							var cal1 = new CalendarPopup();
							</script>
                          <a href="#" onclick="cal1.select(document.FormInsert.Insert11[0],'anchor1','MM/dd/yyyy'); return false;" title="cal1.select(document.FormInsert.Insert11[0],'anchor1','MM/dd/yyyy'); return false; " name="anchor1" id="anchor1"><img src="cal.gif" width="17" height="17" border="0" alt="Click Here to Pick up the timestamp"></a><br>
                          <input type="hidden" value="Table:scan_event~Field:scan_date~Order:10~Type:Date~SqlThread:1" name="Insert11"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Modality:</b>
                        </td>
                        <td colspan="3">
                            <select name="Insert60">
                                <option value="<%=modality%>"><%=modality%></option>
                                <lattice:latticeDropDownList datasource="main"  table='modality' listColumn='modality' pkColumn='modality'/>
                            </select>
                          <input type="hidden" value="Table:volume~Field:modality~Order:60~Type:String~SqlThread:3" name="Insert60">
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Image State:</b>
                        </td>
                        <td colspan="3">
                            <select name="Insert61">
                                <option value="<%=state%>"><%=state%></option>
                                <lattice:latticeDropDownList datasource="main" table='volume_state' listColumn='state' pkColumn='state'/>
                            </select>
                          <input type="hidden" value="Table:volume~Field:state~Order:61~Type:String~SqlThread:3" name="Insert61">
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>File Format:</b>
                        </td>
                        <td colspan="3">
                            <select name="Insert31">
                                <option value="<%=file_format%>"><%=file_format%></option>
                                <lattice:latticeDropDownList datasource="main" table='file_format' listColumn='file_format' pkColumn='file_format'/>
                            </select>
                          <input type="hidden" value="Table:volume~Field:file_format~Order:3~Type:String~SqlThread:3" name="Insert31">
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Numerical Format:</b>
                        </td>
                        <td colspan="3">
                            <select name="Insert33">
                                <option value="<%=numerical_format%>"><%=numerical_format%></option>
                                <lattice:latticeDropDownList datasource="main" table='numerical_format' listColumn='numerical_format' pkColumn='numerical_format'/>
                            </select>
                            <input type="hidden" value="Table:volume~Field:numerical_format~Order:5~Type:String~SqlThread:3" name="Insert33">
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Scanner ID:</b>
                        </td>
                        <td colspan="3">
                          <select name="Insert3"><option selected="true" value=<%=scanner_id%> ><%=scanner_id%></option><mrald:dropDownList datasource="main" table='scanner' listColumn='scanner_id' pkColumn='scanner_id'/>
                          </select><input type="hidden" value="Table:scan_event~Field:scanner_id~Order:3~Type:String~SqlThread:1" name="Insert3"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Grant Number:</b>
                        </td>
                        <td colspan="3">
                          <select name="Insert4"><option selected="true" value=<%=grant_no%> ><%=grant_no%></option><mrald:dropDownList datasource="main" table='project' listColumn='grant_no' pkColumn='grant_no'/>
                          </select><input type="hidden" value="Table:scan_event~Field:grant_no~Order:4~Type:String~SqlThread:1" name="Insert4"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Sequence:</b>
                        </td>
                        <td colspan="3">
                          <input type="text" length="30" name="Insert6" value=<%=sequence%> > (e.g., T1-FFE)</input><input type="hidden" value="Table:scan_event~Field:sequence~Order:6~Type:String~SqlThread:1" name="Insert6"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Flip Angle:</b>
                        </td>
                        <td>
                          <input type="text" length="30" name="Insert8"> (e.g., 30) <input type="hidden" value="Table:scan_event~Field:flip_angle~Order:7~Type:Numeric~SqlThread:1" name="Insert8"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Excitations:</b>
                        </td>
                        <td colspan="3">
                          <input type="text" length="30" name="Insert9" value=<%=excitations%> > (e.g., 1)</input><input type="hidden" value="Table:scan_event~Field:excitations~Order:8~Type:Numeric~SqlThread:1" name="Insert9"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Slice Thickness:</b>
                        </td>
                        <td colspan="3">
                          <input type="text" length="30" name="Insert10" value=<%=thickness%> > mm (e.g. 1.4)</input><input type="hidden" value="Table:scan_event~Field:slice_thickness~Order:9~Type:Numeric~SqlThread:1" name="Insert10"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Software Version:</b>
                        </td>
                        <td colspan="3">
                          <input type="text" length="30" name="Insert12" value=<%=sw_version%>  ></input><input type="hidden" value="Table:scan_event~Field:software_version~Order:11~Type:String~SqlThread:1" name="Insert12"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>TR:</b>
                        </td>
                        <td colspan="3">
                          <input type="text" length="30" name="Insert13" value=<%=tr %> > (e.g., 0.01775478)</input><input type="hidden" value="Table:scan_event~Field:tr~Order:12~Type:Numeric~SqlThread:1" name="Insert13"><br>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>TE:</b>
                        </td>
                        <td colspan="3">
                          <input type="text" length="30" name="Insert14" value=<%=te%> > (e.g., 0.01029678)</input><input type="hidden" value="Table:scan_event~Field:te~Order:14~Type:Numeric~SqlThread:1" name="Insert14"><br>
                        </td>
                      </tr>
					  <tr>
					    <td colspan="4"><center><H2>&nbsp;<b>d i m e n s i o n s : &nbsp;t i m e&nbsp; d o m a i n  </b></H2></center></td>
					  </tr>
					  <tr>
                        <td><b>X:</b></td>
                        <td colspan="3"><input type="text" length="30" name="Insert23" value=<%=xtime%> ></input><input type="hidden" value="Table:scan_event~Field:freq_encode_step_x~Order:4~Type:Numeric~SqlThread:1" name="Insert23"/><br/></td>
					  </tr>
                      <tr>
                        <td><b>Y:</b></td>
                        <td colspan="3"><input type="text" length="30" name="Insert24" value=<%=ytime%> ></input><input type="hidden" value="Table:scan_event~Field:freq_encode_step_y~Order:5~Type:Numeric~SqlThread:1" name="Insert24"/><br/></td>
				      </tr>
                      <tr>
                         <td><b>Z:</b></td>
                         <td colspan="3"><input type="text" length="30" name="Insert25" value=<%=ztime%> ></input><input type="hidden" value="Table:scan_event~Field:freq_encode_step_z~Order:6~Type:Numeric~SqlThread:1" name="Insert25"/><br/></td>
					  </tr>
					  <tr>
					   <td colspan="4"><center><H2><b>&nbsp;d i m e n s i o n s : &nbsp;s p a t i a l / f r e q</b></H2></center></td>
					  </tr>
					  <tr>
                        <td>
                          <b>X :</b>
                        </td>
                        <td>
                          <input type="text" length="30" name="Insert34" value="<%=xdimension%>" ><input type="hidden" value="Table:volume~Field:xdimension~Order:6~Type:Numeric~SqlThread:3" name="Insert34"><br>
                        </td>
                         <td>
                          <b>X Orientation:</b>
                        </td>
                        <td>
                           <select name="Insert38">
                               <option selected="true" value="<%=xorientation%>" ><%=xorientation%></option>
                               <mrald:dropDownList datasource="main" table='orientation' listColumn='orientation' pkColumn='orientation'/></select>
							   <input type="hidden" value="Table:volume~Field:xorientation~Order:22~Type:String~SqlThread:3" name="Insert38">
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <b>Y:</b>
                        </td>
                        <td>
                          <input type="text" length="30" name="Insert39" value="<%=ydimension%>" ><input type="hidden" value="Table:volume~Field:ydimension~Order:11~Type:Numeric~SqlThread:3" name="Insert39"><br>
                        </td>
                        <td>
                          <b>Y Orientation:</b>
                        </td>
                        <td>
                          <select name="Insert43">
                            <option selected="true" value="<%=yorientation%>" ><%=yorientation%></option>
                               <mrald:dropDownList datasource="main" table='orientation' listColumn='orientation' pkColumn='orientation'/></select>
                               <input type="hidden" value="Table:volume~Field:yorientation~Order:23~Type:String~SqlThread:3" name="Insert43">
                        </td>
                      </tr>
                     <tr>
                        <td>
                          <b>Z :</b>
                        </td>
                        <td>
                          <input type="text" length="30" name="Insert44" value="<%=zdimension%>" ><input type="hidden" value="Table:volume~Field:zdimension~Order:16~Type:Numeric~SqlThread:3" name="Insert44"><br>
                        </td>
                        <td>
                          <b>Z Orientation:</b>
                        </td>
                        <td>
                          <select name="Insert48">
                            <option selected="true" value="<%=zorientation%>" ><%=zorientation%></option>
                               <mrald:dropDownList datasource="main" table='orientation' listColumn='orientation' pkColumn='orientation'/></select>
                               <input type="hidden" value="Table:volume~Field:zorientation~Order:24~Type:String~SqlThread:3" name="Insert48">
						</td>
                      </tr>
					  <tr>
                         <td><b>X FOV:</b></td>
                         <td><input type="text" length="30" name="Insert50" value=<%=xfov%> ></input><input type="hidden" value="Table:volume~Field:xfov~Order:10~Type:Numeric~SqlThread:3" name="Insert50"/><br/></td>
						 <td>
                          <b>X Resolution:</b>
                         </td>
                         <td>
                          <input type="text" length="30" name="Insert35" value=<%=xresolution%>><input type="hidden" value="Table:volume~Field:xresolution~Order:7~Type:Numeric~SqlThread:3" name="Insert35"> mm (e.g., 1.0)<br>
                         </td>
					  </tr>
                      <tr>
                         <td><b>Y FOV:</b></td>
                         <td><input type="text" length="30" name="Insert51" value=<%=yfov%> ></input><input type="hidden" value="Table:volume~Field:yfov~Order:8~Type:Numeric~SqlThread:3" name="Insert51"/><br/></td>
						 <td>
                          <b>Y Resolution:</b>
                        </td>
                        <td>
                          <input type="text" length="30" name="Insert40" value=<%=yresolution%>><input type="hidden" value="Table:volume~Field:yresolution~Order:12~Type:Numeric~SqlThread:3" name="Insert40"> mm (e.g., 1.0)<br>
                        </td>
					  </tr>
                      <tr>
                         <td><b>Z FOV:</b></td>
                         <td><input type="text" length="30" name="Insert52" value=<%=zfov%> ></input><input type="hidden" value="Table:volume~Field:zfov~Order:9~Type:Numeric~SqlThread:3" name="Insert52"/><br/></td>
						 <td>
                          <b>Z Resolution:</b>
                         </td>
                         <td>
                          <input type="text" length="30" name="Insert45" value=<%=zresolution%>><input type="hidden" value="Table:volume~Field:zresolution~Order:17~Type:Numeric~SqlThread:3" name="Insert45"> mm (e.g., 1.0)<br>
                        </td>
					  </tr>
                      <tr>
					    <td colspan="4" align="left"><font  color="#FF0000">*</font><b>Fields marked with an asterisk are required</b></td>
					  </tr>
					</table>
                  </td>
                </tr>
              </table>
        <br>
        <div align="center">
          <input value="Submit Data" style="background:#396db9;color:white;" type="submit"><br>
          <br>
          <input value="Reset Form" style="background:#4088b8;color:#c8c8c8;" type="reset">
        </div>
      </form>
           <br/>
       <h2></h2>
    </div>
    <%@include file='menus.jsp'%>
  </body>
</html>

