<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.*" %>
<%@ page import="java.io.*,java.util.*,org.mitre.mrald.taglib.*,org.mitre.mrald.util.*,java.sql.*" %>
<mrald:validate />
<%
 	 String study = WebUtils.getOptionalParameter( request, "study" );
     String level = "";
     MraldConnection conn = new MraldConnection(MetaData.ADMIN_DB);
    String query = "select security_setting from project_security where grant_name='" + study + "'";
    ResultSet rs = conn.executeQuery( query );
    String currentLevel;
    if( rs.next() )
    {
        level = rs.getString("security_setting");
    }
    else
    {
        throw new RuntimeException("No project named " + study + " exists." );
    }

%>
<html>
    <head>
        <%@include file='title.html'%>
    </head>
    <body>
        <div id="wrap">
            <%@include file='pageHeader.jsp'%>

            <div id="content">
                <h2><strong> Project Access Settings for <span class="gray"><%=study%></span></strong></h2>
                <br/>
                <ul style="margin-bottom:0px; padding-bottom:0px;">
                    <li>
                        New sharing level (currently <%=level%>):
                        <form enctype="x-www-form-urlencoded" action="changeSharingStatus.jsp" method="POST" ><select name="newStatus">
                                <option><%=level%></option>
                                <option>Private</option>
                                <%-- <option>Atlas Only</option> --%>
                                <option>Public</option>
                            </select>
                            <input type="hidden" name="projectName" value="<%=study%>" />
                            <input type="submit" value="Change Level"/>
                        </form>
                    </li>
                    <li>
                        Project owners:
                        <ul>
                            <%
                                conn = new MraldConnection( MetaData.ADMIN_DB );
                                rs = conn.executeQuery( "select pi_email from project where grant_name like '%"+ study +"%'" );
                                if( rs.next() )
                                {
                                    String[] emails = rs.getString(1).split(",");
                                    for(int i = 0; i < emails.length; i++)
                                    {
                                        out.write( "<li>" + emails[i] + "</li>" );
                                    }
                                }
                                rs.close();
                            %>
                        </ul>
                    </li>
                    <li>
                        Project members:
                        <ul>
                            <%
                                conn = new MraldConnection( MetaData.ADMIN_DB );
                                rs = conn.executeQuery( "select email from people where latticegroupid like '%"+ study +"%'" );
                                while( rs.next() )
                                {
                                    out.write( "<li><form enctype=\"x-www-form-urlencoded\" action=\"removeMember.jsp\" method=\"POST\" >");
                                    out.write( rs.getString(1) + " <input type=\"submit\" value=\"Remove User\"/>" );
                                    out.write( "<input type=\"hidden\" name=\"study\" value=\"" + study + "\" />");
                                    out.write( "<input type=\"hidden\" name=\"newMember\" value=\"" + rs.getString(1) + "\" /></form></li>");
                                }
                                rs.close();
                            %>
                        </ul>
                        <ul>
                            <li>
                                <form enctype="x-www-form-urlencoded" action="addMember.jsp" method="POST" >
                                    <select name="newMember" />
                                    <%
                                        rs = conn.executeQuery( "select email from people where latticegroupid not like '%"+ study +"%'" );
                                        while( rs.next() )
                                        {
                                            out.write( "<option>" + rs.getString(1) + "</option>" );
                                        }
                                        rs.close();
                                        conn.close();
                                    %>
                                    <input type="submit" value="Add User"/>
                                    <input type="hidden" name="study" value="<%=study%>" />
                                </form>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <%@include file='menus.jsp'%>
        <%-- menu.jsp includes close for wrap <div> --%>
    </body>
</html>

