<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.*" %>
<%@ taglib prefix="tags" tagdir="/WEB-INF/tags" %>
<mrald:validate />
<%
    String subjectID = WebUtils.getRequiredParameter(request, "subject_id");
%>
<html>
    <head>
        <%@include file='title.html'%>
        <script language="JavaScript1.2" type="text/javascript" src="showEvent.js"></script>
    </head>
    <body style="background:#ffffff url(images/background-wide.gif) top center repeat-y;">
        <div id="wrap" style="width:1280px">
            <%@include file='pageHeader.jsp'%>

            <div id="content" style="width:1024px;">
                <h2><strong>Information for subject <span class="gray"><%=subjectID%></span></strong></h2>
                <br/>
                <div style="width:350px;float:left">
                    <tags:subjectInfo id="<%=subjectID%>"/>
                </div>
                <div id="infobox" style="float:right; border: 2px #4088b8 solid;width:600px;height=800px; padding:1em;">
                <jsp:include page="showSubjectEvent.jsp?subject_id=<%=subjectID%>"/>
                </div>
                <br clear="all"/>
            </div>
            <%@include file="menus.jsp"%>
        <%-- menu.jsp includes close for wrap <div> --%>
    </body>
</html>

