<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="../ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.*" %>
<%@ page import="org.mitre.mrald.util.User" %>
<%@ page import="org.mitre.mrald.util.Config" %>
<%@ page import="org.mitre.mrald.util.*,javax.servlet.jsp.*,java.io.*" %>
<%@ page import="java.util.*,org.mitre.neuro.*,org.mitre.mrald.util.*,java.sql.*, org.mitre.neuro.containers.*" %>
<mrald:validate />
<%
    String username =request.getParameter("username");

        if(username == null){
                User mraldUser = (User)session.getAttribute(Config.getProperty("cookietag"));
                 username = mraldUser.getEmail();
                 username = username.substring(0, username.indexOf('@'));
        }
       if(username.equals("admin") || username.equals("atlas")){
                 username = "atlas-admin";
       }
    System.out.println("username" + username);
//    String username = WebUtils.getRequiredParameter(request, "username");
    String study = WebUtils.getRequiredParameter(request, "study");
%>
<html>
    <head>
        <%@include file="title.html"%>
    </head>
    <body>
        <div id="wrap">
            <%@include file="pageHeader.jsp"%>
            <div id="content">
                <h2><strong> Upload status for <span class="gray"><%=study %></span></strong></h2><br/>
                <%
                    MraldConnection mconn = new MraldConnection( "main" );
                    Upload upload = new Upload( mconn.getConnection(), study);

                    File incomingDir = new File(Config.FILE_SEPARATOR
                                                + "home" + Config.FILE_SEPARATOR
                                                + username + Config.FILE_SEPARATOR
                                                + "uploads" );
                    if ( ! incomingDir.exists()){
                        out.write("Upload directory ("+incomingDir.getPath()+") not found<br>You need to create an account before you can proceed\n");
                    }
                    else {
                      System.out.println( incomingDir.getCanonicalPath() );
                       List<Session> scans =null;
                       try {
                         scans = upload.merge(incomingDir);
                       } catch (Exception e) {
                         out.write("could not complete upload:<br> " + e.getMessage());
                         e.printStackTrace();
                       }
                       if (scans != null){
                        if(scans.size() == 0){
                            out.write("No metadata uploaded for " + study);
                            out.write("<br>\nMake sure you upload your xls file");
                            out.write("<br>\nand fill in the project name correctly");
                        }
                        else
                            for( Session s : scans )
                            {
                                List<Session.Image> sImages = s.getImages();
                                boolean allUploaded = true;
                                for( Session.Image si : sImages )
                                {
                                    allUploaded = allUploaded && !si.missing;
                                }
                                if( allUploaded )
                                {
                                    for( Session.Image si : sImages )
                                    {
                                        out.write( si.filename );
                                        if(si.missing)
                                        {
                                            out.write( " not uploaded yet.<br/>Please verify this is a valid package before trying to merge this into our database.\n" );
                                        }
                                        else
                                        {
                                            out.write(" has been enqueued.<br/>\n");
                                        }
                                    } //end for
                                }//end if
                                else
                                {
                                   out.write("You are missing files in your package. Please upload the remaining files " +
                                       "or remove them from the spreadsheet.  You can use <a href\"uploadStatus.jsp?study="+study+"\">this link</a> to check which files are missing.");
                                   break;
                                }
                            } //end for
                       }
                    }
                %>
            </div>
            <%@include file='menus.jsp'%>
        <%-- menu.jsp includes close for wrap <div> --%>
    </body>
</html>

