<%--
Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 --%>
<%@ taglib uri="/WEB-INF/mrald.tld" prefix="mrald"%>
<%@ taglib uri="/WEB-INF/lattice.tld" prefix="lattice"%>
<%@ page errorPage="ErrorHandler.jsp" %>
<%@ page import="org.mitre.mrald.util.*" %>
<%@ page import="org.mitre.mrald.util.User" %>
<%@ page import="org.mitre.mrald.util.Config" %>
<%@ page import="org.mitre.mrald.util.*,javax.servlet.jsp.*,java.io.*" %>
<%@ page import="java.util.*,org.mitre.neuro.*,org.mitre.mrald.util.*,java.sql.*, org.mitre.neuro.containers.*" %>
<mrald:validate />
<%
    String username =request.getParameter("username");

        if(username == null){
                User mraldUser = (User)session.getAttribute(Config.getProperty("cookietag"));
                 username = mraldUser.getEmail();
                 username = username.substring(0, username.indexOf('@'));
        }
       if(username.equals("admin") || username.equals("atlas")){
                 username = "atlas-admin";
       }
       System.out.println("username:" + username);
       String study = WebUtils.getRequiredParameter(request, "study");
%>
<html>
    <head>
        <%@include file="title.html"%>
    </head>
    <body>
        <div id="wrap">
            <%@include file="pageHeader.jsp"%>
            <div id="content">
                <h2><strong> Upload status for <span class="gray"><%=study %></span></strong></h2><br/>
                <%
                    MraldConnection mconn = new MraldConnection( "main" );
                    Upload upload = new Upload( mconn.getConnection(), study);

                    File incomingDir = new File(Config.FILE_SEPARATOR
                            + "home" + Config.FILE_SEPARATOR
                            + username + Config.FILE_SEPARATOR
                            + "uploads" );
                    if ( ! incomingDir.exists())
                    {
                        out.write("Upload directory ("+incomingDir.getPath()+") not found<br>You need to create an account before you can proceed\n");
                    }
                    else
                    {
                        System.out.println( incomingDir.getCanonicalPath() );
                        List<Session> scans =null;
                        try
                        {
                            scans = upload.validate(incomingDir);
                        }
                        catch (Exception e)
                        {
                            out.write("could not complete upload:<br> " + e.getMessage());
                            e.printStackTrace();
                        }
                        if (scans != null)
                        {
                            System.out.println( "Sessions: " + scans.size() );
                            if(scans.size() == 0)
                            {
                                out.write("No metadata uploaded for " + study);
                                out.write("<br>\nMake sure you upload your xls file");
                                out.write("<br>\nand fill in the project name correctly");
                            }
                            else
                            {
                                System.out.println( "scans is null!!" );
                                out.write("Please verify all the files you want to load are marked as uploaded.<br><br>\n");
                            }
                            for( Session s : scans )
                            {
                                // System.out.println( String.valueOf(s) );
                                List<Session.Image> sImages = s.getImages();
                                System.out.println( "Session " + s.getSession_id() + " has " + sImages.size() + " images" );
                                for( Session.Image si : sImages )
                                {
                                    out.write( si.filename );
                                    if(si.missing)
                                    {
                                        out.write( " not uploaded yet.<br/>\n" );
                                    }
                                    else
                                    {
                                        out.write(" uploaded.<br/>\n");
                                    }
                                }
                            }
                        }
                        else
                        {
                            System.out.println( "Error retrieving scans" );
                        }
                    }
                %>
            </div>
            <%@include file='menus.jsp'%>
        <%-- menu.jsp includes close for wrap <div> --%>
    </body>
</html>

