/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.eav;

import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.mitre.mrald.util.MraldException;

/**
 *@author     Gail Hamilton
 *@created
 *@version    1.0
 *@see        java.lang.Object
 */
public class EntityElement extends EavElement
{
	/**
	 *  Description of the Field
	 */
	 private static String SPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"25\" height=\"1\"/>";


	/**
	 *  Constructor for the QueryElements object
	 *
	 *@since
	 */
	public EntityElement()  throws MraldException
	{
		super(new String("Entity"));
	}


	/**
	 */
	protected void init() throws MraldException
	{
		//Set up the query that will be used to return the results

		setColName("entity_id");
		if (getDisplayColumn().equals(""))
		{
			setInitQuery("SELECT name, description, type, entity_id FROM ENTITY  ");
		} else
		{
			setColCount(1);
			setInitQuery(" SELECT " + getDisplayColumn() + "," + getColName() + " from Entity ");
		}

	}


	/**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected StringBuffer outputRow(int columnNo) throws MraldException
	{
		try
		{
			if (!isTable)
				return outputRowNonTable(columnNo);

			StringBuffer ret = new StringBuffer("");

			ret.append("<tr>");
			for (int i = 1; i < columnNo + 1; i++)
			{
				if (getPrintVert())
				{
					ret.append("<tr>");

				}

				if (columnNo == 1)
				{
					ret.append("<td><a href='eavFrame.jsp?classType=" + getType() + "&colName=" +URLEncoder.encode(getColName(),"UTF-8")  + "&colValue=" + URLEncoder.encode(getRs().getString(getColName()),"UTF-8") + "' target=\"_parent\">" + getRs().getString(i) + "</a>");
					hasDiv = true;
				} else
				{
					ret.append("<td>" + getRs().getString(i) + "</td>");
				}
				if (getPrintVert())
				{
					ret.append("</tr>");
				}
			}

			if (hasDiv)
			{
			   //ret.append("<tr><td>");
			   //ret.append("<td>");
			   ret.append("<a onClick=\"toggleNonId(this)\" ><img src=\"images/plus.gif\"></a><div style=\"display:none;\">");
			   endSection = "</div>\n</td></tr>";
			   //endSection = "</div>\n</tr>";

			}
			else
			{
				ret.append("</tr>");
			}
			setColValue(getRs().getString(getColName()));
			return ret;


		} catch (SQLException s)
		{
			throw new MraldException(s);
		}
		catch (java.io.UnsupportedEncodingException s)
		{
			throw new MraldException(s);
		}
	}


	/**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected StringBuffer outputRowNonTable(int columnNo) throws MraldException
	{
		try
		{
			StringBuffer ret = new StringBuffer();

			for (int i = 1; i < columnNo + 1; i++)
			{
				/*if (getPrintVert())
				{
					ret.append("<p class=\"sideBarTitle\">");
				}*/

				if (columnNo == 1)
				{

					ret.append(SPACER + "<a href='eavFrame.jsp?classType=" + getType() + "&colName=" + getColName() + "&colValue=" + getRs().getString(getColName()) + "' target=\"_parent\">" + getRs().getString(i) + "</a>");
					hasDiv = true;
				}
				else
				{
					ret.append( getRs().getString(i)) ;
				}

				if (getPrintVert())
				{
						//ret.append("</p>");
						ret.append("<br/>");
				}

			}
			if (hasDiv)
			{

				   ret.append("<a onClick=\"toggleNonId(this)\" ><img src=\"images/plus.gif\"></a><div style=\"display:none;\" class=\"leftSideBar\">");
				   endSection="</div></p>";

			}
			else
			{
				//ret.append("<br/>");
			}
			setColValue(getRs().getString(getColName()));
			return ret;

		} catch (SQLException s)
		{
			throw new MraldException(s);
		}
	}

         /**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected String endHtmlSingle() throws MraldException
	{

		return endSection;
	}

	/**
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	public String insertHtml() throws MraldException
	{
		try
		{
			/*
			 *  prebuild the drop down lists
			 *  they'll be modified later for the specific drop downs
			 */
			setColCount(2);

			int id = 0;

			setInitQuery("SELECT Max(entity_id) + 1 FROM Entity ");

			ResultSet rs = runQuery(getQuery());

			if (rs.next())
			{
				id = rs.getInt(1);
			}

			rs = runQuery("Select type from type");
			String dropDown = null;
			while( rs.next())
			{
				dropDown = dropDown + "<option>" + rs.getString("type") + "</option>";
			}
			rs.close();

			StringBuffer ret = new StringBuffer();

			String[] columns = new String[]{"entity_id", "name", "description", "type"};
			String[] columnNames = new String[]{"Entity Id", "Name", "Description", "Type"};

			String tableName = "entity";
			for (int i = 0; i < columns.length; i++)
			{
				String value = "";
				if (i == 0)
				{
					value = id + "";
				}

				String input = "<tr><td><b>" + columnNames[i] + "</b></td><td><input type=\"text\" length=\"30\" name=\"Insert" + i +
					"\" value=\"" + value + "\"/><input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/><br/></td></tr>";

				if (columns[i].equals("description"))
				{
					input = "<tr><td><b>" + columnNames[i] + "</b></td><td><textarea rows=\"3\" cols=\"60\" wrap=\"soft\" name=\"Insert" + i + "\"></textarea>" +
						"<input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/><br/></td></tr>";

				}

				if (columns[i].equals("type"))
				{
					input = "<tr><td><b>" + columnNames[i] + "</b></td><td><select  name=\"Insert" + i + "\"><option></option>"+ dropDown  + "</select>" +
						"<input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/><br/></td></tr>";

				}
				ret.append(input);
			}
			this.close();
			return ret.toString();
		} catch (SQLException e)
		{
			throw new MraldException();
		}
	}


	/**
	 *@return    The HTML for inclusion in the second form building page.
	 */
	public String deleteHtml()
	{
		/*
		 *  prebuild the drop down lists
		 *  they'll be modified later for the specific drop downs
		 */
		StringBuffer ret = new StringBuffer();

		return ret.toString();
	}


	/**
	 *@return    The HTML for inclusion in the second form building page.
	 */
	public String updateHtml()
	{
		/*
		 *  prebuild the drop down lists
		 *  they'll be modified later for the specific drop downs
		 */
		StringBuffer ret = new StringBuffer();

		return ret.toString();
	}

}

