/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.eav;

import java.net.URLEncoder;
import java.sql.SQLException;

import org.mitre.mrald.util.MraldException;
/**
 *@author     Gail Hamilton
 *@created
 *@version    1.0
 *@see        java.lang.Object
 */
public class SubjectElement extends EavElement
{
	/**
	 *  Description of the Field
	 */
//	 private static String SPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"25\" height=\"1\"/>";

	/**
	 *  Constructor for the QueryElements object
	 *
	 *@since
	 */
	public SubjectElement() throws MraldException
	{
		super(new String("Subject"));
	}


	/**
	 */
	protected void init() throws MraldException
	{
		//Set up the query that will be used to return the results

		String selectStmnt = "SELECT * from subject  ";
		setColName("subject_id");
		if (getDisplayColumn().equals(""))
		{
			selectStmnt = "SELECT * from subject  ";

		} else
		{
			String tableName = "Subject";
			setColCount(1);
			selectStmnt =" SELECT " + tableName + "." + getDisplayColumn() + "," + tableName + "." + getColName() + " from Subject ";
		}

		 setInitQuery(selectStmnt);


	}




	/**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected StringBuffer outputRow(int columnNo) throws MraldException
	{
		try
		{
			if (!isTable)
				return outputRowNonTable(columnNo);

			StringBuffer ret = new StringBuffer();

			ret.append("<tr>");
			for (int i = 1; i < columnNo + 1; i++)
			{
				if (getPrintVert())
				{
					ret.append("<tr>");
				}

				if (columnNo == 1)
				{
					ret.append("<td><a href='eavFrame.jsp?show=Subject&classType=" + getType() + "&colName=" + URLEncoder.encode(getColName(),"UTF-8")  + "&colValue=" + URLEncoder.encode(getRs().getString(getColName()),"UTF-8")  + "' target=\"_parent\">" + getRs().getString(i) + "</a>");
					hasDiv = true;
				} else
				{
					ret.append("<td>" + getRs().getString(i) + "</td>");
				}
				if (getPrintVert())
				{
					ret.append("</tr>");
				}
			}
			if (hasDiv)
			{
			   ret.append("<a onClick=\"toggleNonId(this)\" ><img src=\"images/minus.gif\"></a><div style=\"display:block;\">");
			   endSection = "</div>\n</td></tr>";

			}
			else
			{
				ret.append("</tr>");
			}

			setColValue(getRs().getString(getColName()));
			return ret;
		} catch (SQLException s)
		{
			throw new MraldException(s);
		}
		catch (java.io.UnsupportedEncodingException s)
		{
			throw new MraldException(s);
		}
	}

	/**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected StringBuffer outputRowNonTable(int columnNo) throws MraldException
	{
		try
		{
			StringBuffer ret = new StringBuffer();

			for (int i = 1; i < columnNo + 1; i++)
			{
				/*if (getPrintVert())
				{
					ret.append("<p class=\"sideBarTitle\">");
				}*/

				if (columnNo == 1)
				{

					//ret.append("<p class=\"sideBarTitle\">");
					ret.append("<p class=\"sideBarText\">");

					ret.append("<a href='eavFrame.jsp?show=Subject&classType=" + getType() + "&colName=" +  URLEncoder.encode(getColName(),"UTF-8")+ "&colValue=" + URLEncoder.encode(getRs().getString(getColName()),"UTF-8") + "' target=\"_parent\">" + getRs().getString(i) + "</a>");
					hasDiv = true;
					String temp = "<a onClick=\"toggle('<:IDName:>', 'images/')\" ><img id=\"<:IDName:>Image\" src=\"images/plus.gif\"></a><div id=\"<:IDName:>\" style=\"display:none;\" class=\"leftSideBar\">";
					temp = temp.replaceAll("<:IDName:>",  getRs().getString(i));
					ret.append(temp);
					endSection="</div></p>";

				}
				else
				{
					ret.append( getRs().getString(i)) ;
				}
				if (getPrintVert())
				{
						//ret.append("</p>");
						ret.append("<br/>");
				}

			}
			if (hasDiv)
			{

				   //ret.append("<a onClick=\"toggleNonId(this)\" ><img src=\"images/plus.gif\"></a><div style=\"display:block;\" class=\"leftSideBar\">");
				  endSection="</div></p>";
			}
			else
			{
				//ret.append("</p>");
			}
			setColValue(getRs().getString(getColName()));
			return ret;

		} catch (SQLException s)
		{
			throw new MraldException(s);
		}
		catch (java.io.UnsupportedEncodingException s)
		{
			throw new MraldException(s);
		}
	}
         /**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected String endHtmlSingle() throws MraldException
	{

		return endSection;
	}

	/**
	 *@param  rs  Description of the Parameter
	 *@return     The HTML for inclusion in the second form building page.
	 */
	protected StringBuffer endOutputRow() throws MraldException
	{
		return new StringBuffer("</div>");
	}

	/**
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	public String insertHtml() throws MraldException
	{
		/*try
		{*/
			/*
			 *  prebuild the drop down lists
			 *  they'll be modified later for the specific drop downs
			 */

			StringBuffer ret = new StringBuffer();

			return ret.toString();
		/*} catch (SQLException e)
		{
			throw new MraldException();
		}*/
	}

 /**
	 *@param  rs  Description of the Parameter
	 *@return     The HTML for inclusion in the second form building page.
	 */
	public void setParams(String column, String value)
	{

		String[] values = value.split("~");

		super.setParams( "Subject", column, values[0] );
	}

	 /**
	 *@param  rs  Description of the Parameter
	 *@return     The HTML for inclusion in the second form building page.
	 */
	public void addParams(String columnName, String value)
	{
		super.addParams("Subject", columnName, value);

	}
	/**
	 *@return    The HTML for inclusion in the second form building page.
	 */
	public String deleteHtml()
	{
		/*
		 *  prebuild the drop down lists
		 *  they'll be modified later for the specific drop downs
		 */
		StringBuffer ret = new StringBuffer();

		return ret.toString();
	}


	/**
	 *@return    The HTML for inclusion in the second form building page.
	 */
	public String updateHtml()
	{
		/*
		 *  prebuild the drop down lists
		 *  they'll be modified later for the specific drop downs
		 */
		StringBuffer ret = new StringBuffer();

		return ret.toString();
	}

}

