/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.eav;

import java.sql.SQLException;

import org.mitre.mrald.util.MraldException;

/**
 *@author     Gail Hamilton
 *@created
 *@version    1.0
 *@see        java.lang.Object
 */
public class TypeElement extends EavElement
{
//	private static String SPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"<:width:>\" height=\"1\"/>";

	/**
	 *  Description of the Field
	 */

	/**
	 *  Constructor for the QueryElements object
	 *
	 *@since
	 */
	public TypeElement()  throws MraldException
	{
		super(new String("Type"));
	}


	/**
	 */
	protected void init() throws MraldException
	{
		//Set up the query that will be used to return the results

		if (getDisplayColumn().equals(""))
		{
			setInitQuery("SELECT * FROM Type ");
		} else
		{
			setInitQuery(" SELECT " + getDisplayColumn() + " from Type ");
		}

		setColName("type");
	}


	/**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected StringBuffer outputRow(int columnNo) throws MraldException
	{
		try
		{
			if (!isTable)
				return outputRowNonTable(columnNo);

			StringBuffer ret = new StringBuffer();

			ret.append("<tr>");
			for (int i = 1; i < columnNo + 1; i++)
			{
				if (getPrintVert())
				{
					ret.append("<tr>");

				}

				if (columnNo == 1)
				{
					ret.append("<td>" + getRs().getString(i) );
					hasDiv = true;
				}
				else
				{
					ret.append("<td>" + getRs().getString(i) + "</td>");

				}
				if (getPrintVert())
				{
					ret.append("</tr>");

				}
			}
			if (hasDiv)
			{

				   ret.append("<a onClick=\"toggleNonId(this)\" ><img src=\"images/minus.gif\"></a><div style=\"display:block;\">");
				   ret.append("<table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td class=\"bord\">");
				   ret.append("<table summary=\"\" width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\"><tr><td>");
				   endSection = "</td></tr></table></td></tr></table></div>\n</td></tr>";
			}
			else
			{
				ret.append("</tr>");
			}
			return ret;

		} catch (SQLException s)
		{
			throw new MraldException(s);
		}
	}

/**
	 *@param  columnNo            Description of the Parameter
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	protected StringBuffer outputRowNonTable(int columnNo) throws MraldException
	{
		try
		{
			StringBuffer ret = new StringBuffer();

			for (int i = 1; i < columnNo + 1; i++)
			{
				/*if (getPrintVert())
				{
					ret.append("<p class=\"sideBarTitle\">");
				}*/

				if (columnNo == 1)
				{

					ret.append("<p class=\"sideBarTitle\">");
					ret.append(getRs().getString(i) );
					hasDiv = true;
					String temp = "<a onClick=\"toggle('<:IDName:>', 'images/')\" ><img id=\"<:IDName:>Image\" src=\"images/minus.gif\"></a><div id=\"<:IDName:>\" style=\"display:block;\" class=\"leftSideBar\">";
					temp = temp.replaceAll("<:IDName:>",  getRs().getString(i));
					// ret.append("<a onClick=\"toggle('<:IDName:>', 'images/')\" ><img id=\"<:IDName:>Image\" src=\"images/plus.gif\"></a><div id=<:IDName:> style=\"display:block;\" class=\"leftSideBar\">");
					ret.append(temp);
					endSection="</div></p>";

				}
				else
				{
					ret.append( getRs().getString(i)) ;
				}
				if (getPrintVert())
				{
						//ret.append("</p>");
						ret.append("<br/>");
				}

			}
			if (hasDiv)
			{

				   //ret.append("<a onClick=\"toggleNonId(this)\" ><img src=\"images/plus.gif\"></a><div style=\"display:block;\" class=\"leftSideBar\">");

			}
			else
			{
				//ret.append("</p>");
			}
			return ret;

		} catch (SQLException s)
		{
			throw new MraldException(s);
		}
	}



	/**
	 *@return                     The HTML for inclusion in the second form
	 *      building page.
	 *@exception  MraldException  Description of the Exception
	 */
	public String insertHtml() throws MraldException
	{

			/*
			 *  prebuild the drop down lists
			 *  they'll be modified later for the specific drop downs
			 */
			setColCount(2);

			//MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "Type Element : Query  " );

			StringBuffer ret = new StringBuffer();

			String[] columns = new String[]{"type", "description"};
			String[] columnNames = new String[]{"Type", "Description"};

			String tableName = "type";
			for (int i = 0; i < columns.length; i++)
			{

				String input = "<tr><td><b>" + columnNames[i] + "</b></td><td><input type=\"text\" length=\"30\" name=\"Insert" + i +
					"\" /><input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/><br/></td></tr>";

				if (columns[i].equals("description"))
				{
					input = "<tr><td><b>" + columnNames[i] + "</b></td><td><textarea rows=\"3\" cols=\"60\" wrap=\"soft\" name=\"Insert" + i + "\"></textarea>" +
						"<input type=\"hidden\" value=\"Table:" + tableName + "~Field:" + columns[i] + "~Order:" + i + "~Type:String\" name=\"Insert" + i + "\"/><br/></td></tr>";

				}
				ret.append(input);
			}
			return ret.toString();

	}


	/*
	 *@param  colName  The new colName value
	 */
	public void setIsTable(boolean isTable)
	{
		this.isTable= isTable;

	}

	/**
	 *@return    The HTML for inclusion in the second form building page.
	 */
	public String deleteHtml()
	{
		/*
		 *  prebuild the drop down lists
		 *  they'll be modified later for the specific drop downs
		 */
		StringBuffer ret = new StringBuffer();

		return ret.toString();
	}


	/**
	 *@return    The HTML for inclusion in the second form building page.
	 */
	public String updateHtml()
	{
		/*
		 *  prebuild the drop down lists
		 *  they'll be modified later for the specific drop downs
		 */
		StringBuffer ret = new StringBuffer();

		return ret.toString();
	}


}

