/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.graph;

import org.mitre.mrald.util.MetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.User;


/**
 *@author     Gail Hamilton
 *@created    November 4, 2003
 */

public class GraphSelect extends AbstractStep
{
	private static MraldConnection conn = null;

	private static int graphId = 0;
	private static String prevUserId = "";
	/**
	 *  Constructor for the AllTablesListTag object
	 */
	public GraphSelect() throws ClassNotFoundException, SQLException
	{
		conn = new MraldConnection( MetaData.ADMIN_DB );
	}

	public static String getLastGraph(User user) throws SQLException, ClassNotFoundException
	{
		int lastId = graphId;
		String userid = user.getEmail();


		if (graphId == 0 || (!userid.equals(prevUserId)) )
		{
		  String query = " SELECT max(graphid) as maxid from graphs  where userid = '" + userid + "'";
		  if (conn == null)
		  {
			 conn = new MraldConnection( MetaData.ADMIN_DB );
		  }
		  ResultSet rs = conn.executeQuery( query );
		  if ( rs.next() )
                  {
		    lastId = rs.getInt( "maxid" );
		  }
		}
		prevUserId = userid;

		return Config.getProperty("latticeGraph") + "_" + userid +  "_" + lastId;

	}

	public static String getPrevGraph(User user) throws SQLException, ClassNotFoundException
	{
		int prevId = graphId;
		String userid = user.getEmail();
		if (graphId == 0 || (!userid.equals(prevUserId)))
		{
		  String query = " SELECT max(graphid) as maxid from graphs  where userid = '" + userid + "'";
		  if (conn == null)
		  {
			 conn = new MraldConnection( MetaData.ADMIN_DB );
		  }
		  ResultSet rs = conn.executeQuery( query );
		  if ( rs.next() )
                  {
		    prevId = rs.getInt( "maxid" ) - 1;
		  }
		}
		prevUserId = userid;

		return Config.getProperty("latticeGraph") + "_" + userid  + "_" + prevId;

	}

	public String setNewGraph(User user) throws SQLException, ClassNotFoundException
	{
		int lastId = graphId;

		String userid = user.getEmail();

		if (graphId == 0 || (!userid.equals(prevUserId)))
		{
		    if (conn == null)
		    {
			 conn = new MraldConnection( MetaData.ADMIN_DB );
		    }
		    String query = " SELECT max(graphid) as maxid from graphs where userid = '" + userid + "' order by maxid ";
		    ResultSet rs = conn.executeQuery( query );
		    if ( rs.next() )
                    {
		        lastId = rs.getInt( "maxid" ) + 1;
		    }
		}
		else
		{
	           lastId = graphId++;
		}
		String insert = "Insert into graphs values (" + lastId + ",'" + userid + "' )";

		conn.executeUpdate( insert);

		prevUserId = userid;

		return Config.getProperty("latticeGraph") + "_" + userid+ "_" + lastId;

	}

	 public void execute(MsgObject msg) throws WorkflowStepException
	 {
		 try
		 {


		 }
		 catch( Exception e)
		 {
	             throw new WorkflowStepException( e) ;
		 }

	 }

	 public void cleanUp() throws SQLException
	{
		conn.close();
		conn = null;
	}

	 /*public void close() throws SQLException
	{
		conn.close();
	}*/

	 public void close()
	{
		try
		{
		    conn.close();
		    conn= null;
		}
		catch(Exception e)
		{}
	}
}

