/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.graph;

import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.mitre.mrald.util.Config;
/**
 *  Class that contains any functions that deal with Graphing of the Lattice
 *  objects, using JGraph as a graphical interface.
 *
 *@author     ghamilton
 *@created    December 12, 2003
 */

 public class MraldGraph extends JGraph {

	public MraldGraph()
	{
		this(null);
	}

	public MraldGraph(GraphModel model) {
		this(model, null);
	}

	public MraldGraph(GraphModel model, GraphLayoutCache view) {
		super(model, view, null);

	}

	 protected VertexView createVertexView(JGraph graph, CellMapper cm,
			Object cell)
	{
		return Config.getLatticeFactory().createView(cell, this, cm);
	}
}
