/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.graph;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.MsgObjectException;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;

/**
 *This function is a wrapper class for graphing the Users Lattice.
 *Based on a login.
 *@author     ghamilton
 *@created    November 12, 2003
 */
public class RedrawGraph extends AbstractStep
{

    /**
     *  Constructor for the GraphUserLattice object
     */
    public RedrawGraph() {
        try {

        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void graphLattice(MsgObject msg) throws  org.mitre.mrald.control.WorkflowStepException, MraldException
    {
        try {

                HttpServletRequest req = msg.getReq();
        HttpSession ses = req.getSession();
        /* UserGroup userGroup = null;
        User user = null; */
        if (ses == null)
        {
            HttpServletResponse resp = msg.getRes();

            resp.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeLogin.jsp?pageurl=" + req.getRequestURL());
            return;
        }
        else
        {
            /* user = (User) ses.getAttribute(Config.getProperty("cookietag"));
            userGroup = new UserGroup(user.getGroup()); */
        }
            //Pass in the keyNode value to be used to filter the
            //groups that are displayed in the AddNode.jsp
            User user = ( User ) ses.getAttribute( Config.getProperty( "cookietag" ) );

	    String output = GraphLattice.convertToHtml(user);

            outputHtml(msg, output);

        }

        catch( ServletException e)
         {
                 throw new WorkflowStepException( e) ;
         }
         catch( IOException e)
         {
                 throw new WorkflowStepException( e) ;
         }
         catch( MsgObjectException e)
         {
                 throw new WorkflowStepException( e) ;
         }
         catch(Exception e)
         {
             throw new WorkflowStepException( e) ;

         }
    }

    /**
    *  This method prepares the output file for the HTML format data
    *
    *@since
    */
    public static void outputHtml(MsgObject msg, String output)
    throws ServletException, IOException, MsgObjectException
    {


            HttpServletResponse res =msg.getRes();
        res.sendRedirect(Config.getProperty("BaseUrl") + "/LatticeManagement.jsp");


        }

     public void execute(MsgObject msg) throws WorkflowStepException
     {
         try
         {
             graphLattice( msg);
             //For User exceptions. Display the error message.
        }catch(Exception e)
        {
            throw new MraldError(e);
        }


     }

}

