/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.lattice;

import java.io.UnsupportedEncodingException;

import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;

/**
 *  Description of the Class
 *
 *@author     gail
 *@created    December 9, 2003
 */
public class LatticeCrypter
{

	private static Cipher ecipher;
	private static Cipher dcipher;


	/**
	 *  Constructor for the SampleEncrypter object
	 *
	 *@param  key  Description of the Parameter
	 */
	public LatticeCrypter(SecretKey key)
	{
		try
		{
			ecipher = Cipher.getInstance("DES");
			dcipher = Cipher.getInstance("DES");
			ecipher.init(Cipher.ENCRYPT_MODE, key);
			dcipher.init(Cipher.DECRYPT_MODE, key);

		}
		catch (javax.crypto.NoSuchPaddingException e)
		{
		}
		catch (java.security.NoSuchAlgorithmException e)
		{
		}
		catch (java.security.InvalidKeyException e)
		{
		}
	}


	/**
	 *  Description of the Method
	 *
	 *@param  str  Description of the Parameter
	 *@return      Description of the Return Value
	 */
	public static String encrypt(String str)
	{
		try
		{
			// Encode the string into bytes using utf-8
			byte[] utf8 = str.getBytes("UTF8");

			// Encrypt
			byte[] enc = ecipher.doFinal(utf8);

			// Encode bytes to base64 to get a string
			return new sun.misc.BASE64Encoder().encode(enc);
		}
		catch (javax.crypto.BadPaddingException e)
		{
		}
		catch (IllegalBlockSizeException e)
		{
		}
		catch (UnsupportedEncodingException e)
		{
		}
		return null;
	}


	/**
	 *  Description of the Method
	 *
	 *@param  str  Description of the Parameter
	 *@return      Description of the Return Value
	 */
	public static String decrypt(String str)
	{
		try
		{
			// Decode base64 to get bytes
			byte[] dec = new sun.misc.BASE64Decoder().decodeBuffer(str);

			// Decrypt
			byte[] utf8 = dcipher.doFinal(dec);

			// Decode using utf-8
			return new String(utf8, "UTF8");
		}
		catch (javax.crypto.BadPaddingException e)
		{
		}
		catch (IllegalBlockSizeException e)
		{
		}
		catch (UnsupportedEncodingException e)
		{
		}
		catch (java.io.IOException e)
		{
		}
		return null;
	}
}

