/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.lattice;

public interface LatticeNodeInterface {

	/* addChildren() will add the specified children to the
	 * list of this Node.
	 */
	public boolean addChildren( java.util.ArrayList nodeChildren ) throws InvalidLatticeStructureException;
	/* addChild() is a private function that will only be called
	 * by the addChildren() function.
	 *
	 * This function will also call the addParent of the node
	 * it is adding to the list.
	 */
	public boolean addChild( LatticeNode child ) throws InvalidLatticeStructureException;


	/* removeChildren() will remove the specified children from the
	 * list of this Node
	 */
	public boolean removeChildren( java.util.ArrayList nodeChildren );
	/* removeChild() is a private function that will only be called
	 * by the removeChildren() function.
	 *
	 * This function will also call the removeParent of the node
	 * it is removing from the list.
	 */
	public boolean removeChild( LatticeNode child );


	/* addParent() is the function that will add the parent to
	 * this node when the Tree has a node added.
	 */
	public boolean addParent( LatticeNode parent ) throws InvalidLatticeStructureException;
	/* removeParent() is the function that will remove the parent
	 * from this node when the Tree has a node removed.
	 */
	public boolean removeParent( LatticeNode parent );


	/* These are the get methods of the member variables. */
	public java.util.ArrayList getParents();
	public java.util.ArrayList getChildren();
	public String getName();


}
