/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.lattice;

import java.util.ArrayList;
/**
 *
 *
 *@author     Gail Hamilton
 *@created    November 4, 2003
 */

public class LatticeUserGroup
{

     private String[] userGroups = new String[10];
     /**
     *  Functions to get the Groups that User is Assigned To
     *
     *@param  sUser login of the User
     */
    public LatticeUserGroup( String sUser )
    {
    String[] userGroups = new String[1];
    userGroups[0] = "Public";
    }

     /***
    May need to remove this later. Right now included for testing purposes.
    */
    public void setUserGroups( String[] setUserGroups)
    {
    userGroups = setUserGroups;
    }

    /***
    Using the login of the User, get the Groups that this User is assigned to.
    */
    public String[] getUserGroups( String user)
    {
    return userGroups;
    }

    /***
    Go through the list of User Groups that that the User is associated
    with and get the one that will provide them with most permissions.
    In general there will only be UserGroup assigned to each person.
    Makes the assumption that the no Of Levels (ie the number of Nodes that a
    particular Group can 'see') is equivalent to the relative access.

    */
    public String getMostDominant( LatticeNode root, String[] UserGroups)
    {

    ArrayList nodes = LatticeFunctions.getMostDominant( root );

    //Cycle through the ARray of Nodes and match against the
    //Groups that the User is assigned to until a match is found.
    //THis is the Group that gives the User most access.
    for (int i = 0; i < nodes.size()  ; i++)
    {
        String groupName = ((LatticeNode)nodes.get(i)).getName();

        for (int j = 0; j < UserGroups.length; j++)
        {
                if ( groupName.equals(UserGroups[j]) ) return groupName;
        }
    }

    //If no Node found then just assign default
    return new String("Public");
    }

    /***
    Go through the list of User Groups that that the User is associated
    with and get the one that will provide them with most permissions.
    In general there will only be UserGroup assigned to each person.
    Makes the assumption that the no Of Levels (ie the number of Nodes that a
    particular Group can 'see') is equivalent to the relative access.

    Recursively step down the levels until a match is reached.
    This will be the Security Group that the User is assigned to.

    */
    public String getMostDominant( LatticeNode root)
    {

    ArrayList nodes = LatticeFunctions.getMostDominant( root );
    int k =0;
    boolean notFound = true;

    //Cycle through each level until a match is found
    while ((notFound) && (k < LatticeFunctions.getMaxLevel()))
    {

        //Cycle through the ARray of Nodes and match against the
        //Groups that the User is assigned to until a match is found.
        //THis is the Group that gives the User most access.
        for (int i = 0; i < nodes.size()  ; i++)
        {

            String groupName = ((LatticeNode)nodes.get(i)).getName();

            for (int j = 0; j < userGroups.length; j++)
            {
                    if ( groupName.equals(userGroups[j]) )
            {
            notFound = false;
                return groupName;
            }
             }
          }
          k++;
          //Go down to the next level. The increment here - decrements the level
          nodes = LatticeFunctions.getMostDominant(k);

    }
    //If no Node found then just assign default
    return new String("Public");
    }
}
