/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.query;

import java.util.ArrayList;

import org.mitre.lattice.graph.GraphUserLattice;
import org.mitre.lattice.lattice.InsufficentGroupAccessException;
import org.mitre.lattice.lattice.InvalidLatticeStructureException;
import org.mitre.lattice.lattice.LatticeErrorHandler;
import org.mitre.lattice.lattice.LatticeException;
import org.mitre.lattice.lattice.LatticeFunctions;
import org.mitre.lattice.lattice.LatticeNode;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.lattice.lattice.NodeNotFoundException;
import org.mitre.lattice.lattice.NullLatticeNodeException;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.MraldException;

/**
 *@author     Gail Hamilton
 *@created    November 4, 2003
 */

public class GroupList extends AbstractStep
{

	/**
	 *  Constructor for the AllTablesListTag object
	 */
	public GroupList() { }


	/**
	 *  Gets the body attribute of the BuildForm object
	 *
	 *@param  keyGroup                             Description of the Parameter
	 *@return                                      The body value
	 *@exception  NodeNotFoundException            Description of the Exception
	 *@exception  InsufficentGroupAccessException  Description of the Exception
	 *@exception  MraldException                   Description of the Exception
	 */
	public java.util.List getGroups(String keyGroup)
		throws NodeNotFoundException, InsufficentGroupAccessException, MraldException
	{
		/*
		 *  Produce the table names with the appropriately labeled checkboxs
		 */
//		StringBuffer buffer = new StringBuffer();
		ArrayList allGroups = new ArrayList();

		if (!keyGroup.equals(""))
		{
			allGroups = (ArrayList) getAllGroups(keyGroup);
		}
		else
		{
			allGroups = (ArrayList) getAllGroups();
		}

		return allGroups;
	}

	/**
	 *  Gets the body attribute of the BuildForm object
	 *
	 *@return                                       The body value
	 *@exception  MraldException                    Description of the Exception
	 *@exception  InsufficentGroupAccessException   Description of the Exception
	 *@exception  NodeNotFoundException             Description of the Exception
	 *@exception  NullLatticeNodeException          Description of the Exception
	 *@exception  InvalidLatticeStructureException  Description of the Exception
	 */
	public java.util.List getAllGroups()
		throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException
	{
		LatticeFunctions.setImplmnt();

		LatticeFunctions.setIsSet( false );

		//MraldOutFile.logToFile( Config.getProperty("LOGFILE"), "Getting all groups. No key node.");
		ArrayList allGroups = new ArrayList();
		//Need to rebuild the Lattice. from the stored version

		LatticeTree newLattice = (LatticeTree) GraphUserLattice.getLattice();
		allGroups = LatticeFunctions.getFlatLattice(newLattice.getRootNode());
		/*java.util.List allGroupsSorted = */LatticeFunctions.sort(allGroups);

		return allGroups;
	}

/**
	 *  Gets the body attribute of the BuildForm object
	 *
	 *@return                                       The body value
	 *@exception  MraldException                    Description of the Exception
	 *@exception  InsufficentGroupAccessException   Description of the Exception
	 *@exception  NodeNotFoundException             Description of the Exception
	 *@exception  NullLatticeNodeException          Description of the Exception
	 *@exception  InvalidLatticeStructureException  Description of the Exception
	 */


	/**
	 *  Gets the allGroups attribute of the GroupListTag object
	 *
	 *@param  keyGroup                              Description of the Parameter
	 *@return                                       The allGroups value
	 *@exception  InsufficentGroupAccessException   Description of the Exception
	 *@exception  NodeNotFoundException             Description of the Exception
	 *@exception  NullLatticeNodeException          Description of the Exception
	 *@exception  InvalidLatticeStructureException  Description of the Exception
	 *@exception  MraldException                    Description of the Exception
	 */
	public java.util.List getAllGroups(String keyGroup)
		throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException
	{

		LatticeFunctions.setImplmnt();

		ArrayList allGroups = new ArrayList();

		//Need to rebuild the Lattice.
		LatticeTree newLattice = (LatticeTree) GraphUserLattice.getLattice();

		LatticeNode key = null;
		try
		{
			key = newLattice.searchTree(keyGroup);
		}
		catch (NodeNotFoundException e)
		{
			//Users should alway sbe allowed to access the Root node
			/*if (!keyGroup.equals("Public") )
			{
		            LatticeException latticeErr = null;
			    latticeErr = new InsufficentGroupAccessException("LATT-003");
			    LatticeErrorHandler.handleException(null, latticeErr, true);
			}*/
			key = newLattice.getRootNode();
			//throw new InsufficentGroupAccessException("You have insufficent privilidges to access this system. Please contact your system Administrator." + e.getDetail());
		}

		if (key != newLattice.getRootNode())
		{
			LatticeTree childTree = new LatticeTree((LatticeNode) LatticeFunctions.getChildTree(key));


			LatticeFunctions.setIsSet( false);
			if ((childTree == null) || (childTree.getRootNode() == null))
			{
				LatticeException latticeErr = null;
			        latticeErr = new InsufficentGroupAccessException("LATT-003");
			        LatticeErrorHandler.handleException(null, latticeErr, true);
				//throw new InsufficentGroupAccessException("You have insufficent privilidges to access this system. Please contact your system Administrator.");
			}

			allGroups = LatticeFunctions.getFlatLattice(childTree.getRootNode());
			java.util.List allGroupsSorted = LatticeFunctions.sort(allGroups);

			return allGroupsSorted;
		}
		else
		{

			//LatticeTree childTree = new LatticeTree(Config.getLatticeFactory().copyNode(key));
			allGroups = LatticeFunctions.getFlatLattice(newLattice.getRootNode());
			return allGroups;
		}
	}

	/**
	 *  Wrapper class to convert all exceptions to MraldException
	 */
	public java.util.List getChildren(String keyGroup)
		throws MraldException
	{
	    try
	    {
                return getChildGroups(keyGroup);
	    }
	    catch(InsufficentGroupAccessException e)
	    {
	        throw new MraldException(e.getMessage());
	    }
	    catch(NodeNotFoundException e)
	    {
	        throw new MraldException(e.getMessage());
	    }
	    catch( NullLatticeNodeException e)
	    {
	        throw new MraldException(e.getMessage());
	    }
	    catch(InvalidLatticeStructureException e)
	    {
	        throw new MraldException(e.getMessage());
	    }
	}
	/**
	 *  Gets the allGroups attribute of the GroupListTag object
	 *
	 *@param  keyGroup                              Description of the Parameter
	 *@return                                       The allGroups value
	 *@exception  InsufficentGroupAccessException   Description of the Exception
	 *@exception  NodeNotFoundException             Description of the Exception
	 *@exception  NullLatticeNodeException          Description of the Exception
	 *@exception  InvalidLatticeStructureException  Description of the Exception
	 *@exception  MraldException                    Description of the Exception
	 */
	public java.util.List getChildGroups(String keyGroup)
		throws InsufficentGroupAccessException, NodeNotFoundException, NullLatticeNodeException, InvalidLatticeStructureException, MraldException
	{
		LatticeFunctions.setImplmnt();
                LatticeNode key = null;
		ArrayList<LatticeNode> allGroups = new ArrayList<LatticeNode>();

		LatticeTree newLattice = (LatticeTree) GraphUserLattice.getLattice();
                try
		{
			key = newLattice.searchTree(keyGroup);
		}
		catch (NodeNotFoundException e)
		{
			//Assign the user rights to Public only
			key = newLattice.getRootNode();
		        //LatticeException latticeErr = null;
			//latticeErr = new InsufficentGroupAccessException("LATT-003");
			//LatticeErrorHandler.handleException(null, latticeErr, true);

		}

		allGroups.add(key);
		if (key != newLattice.getRootNode())
		{
			allGroups.addAll(newLattice.children(key));
		}

		return allGroups;
	}

	 public void execute(MsgObject msg) throws WorkflowStepException
	 {
		 try
		 {


		 }
		 catch( Exception e)
		 {
	             throw new WorkflowStepException( e) ;
		 }

	 }
}

