/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.query;

import java.util.Iterator;
import java.util.Set;

import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.formbuilder.FormBuilderElement;
import org.mitre.mrald.parser.ParserElement;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FormTags;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MiscUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 *  Description of the Class
 *
 *@author     ghamilton
 *@created    January 9, 2004
 */
public class LabelElement extends ParserElement implements FormBuilderElement
{
	/**
	 *  Constructor for the LatticeElement object
	 *
	 *@since
	 */

	private String setCOI="";
	public LabelElement() { }


	/**
	 *  Gets the elementType of the ParserElement-derived object
	 *
	 *@return    The elementType value
	 */
	public String getElementType()
	{
		return "Label Element";
	}


	/**
	 *  Gets the elementType of the ParserElement-derived object
	 *
	 *@return    The elementType value
	 */
	public String process()
	{
		return "Label Element";
	}


	/**
	 *  Gets the elementType of the ParserElement-derived object
	 *
	 *@return    The elementType value
	 */
	public String getType()
	{
		return "Label Element";
	}


	/**
	 *  For this element, in it's role as a FormBuilderElement, collect the EndDate
	 *  and main Elements and make sure they all get processed together
	 *  by.........................
	 *
	 *@param  msg          Description of the Parameter
	 *@param  currentName  Description of the Parameter
	 *@return              Description of the Return Value
	 *@since
	 */
	public String preProcess(MsgObject msg, String currentName)
	{


		setCOI =  msg.getValue("COI")[0];

		return currentName;
	}


	/**
	 *  Gets the updateStmnt attribute of the LabelElement object
	 *
	 *@return    The updateStmnt value
	 */
	public String getUpdateStmnt()
	{
		MsgObject msg = getNameValues();
		String[] values = msg.getValue(FormTags.VALUE_TAG);
		String tableName = msg.getValue(FormTags.TABLE_TAG)[0];
		String columnName = msg.getValue("Column")[0];
//		String groupName = msg.getValue("groupName")[0];
		String currentCOI =  msg.getValue("CurrentCOI")[0];
		String updateStart = "Update " + tableName + " set LABEL = '" + setCOI + "' WHERE " + columnName + " = ";
		StringBuffer updateStr = new StringBuffer(updateStart);

		for (int i = 0; i < values.length; i++)
		{
			//String coiVal = MiscUtils.checkApostrophe(values[i]);
			String coiVal = values[i];
			updateStr.append("'" + coiVal + "'");
			if (i < (values.length - 1))
			{
				updateStr.append(",");
			}
		}

		//Check for invalid characters
		 currentCOI = MiscUtils.checkApostrophe(currentCOI);

		updateStr.append(" AND label = '" + currentCOI + "'");


		//getInsertStmnt();

		return new String(updateStr);
	}


	/**
	 *  Gets the updateStmnt attribute of the LabelElement object
	 *
	 *@return    The updateStmnt value
	 */
	public String getInsertStmnt()
	{
		MsgObject msg = getNameValues();
		String[] values = msg.getValue(FormTags.VALUE_TAG);
		String tableName = msg.getValue(FormTags.TABLE_TAG)[0];
		String[] columnNames = msg.getValue("Column");
		String groupName = msg.getValue("groupName")[0];
		String insertStr = "Insert INTO " + tableName + "(LABEL," + columnNames + ") VALUES (  '" + groupName + "'," + values + ")";

		return insertStr;
	}


	/**
	 *@param  metaData  Metadata about the tables the form is based on.
	 *@param  num       Which iteration this is. This should be used to create
	 *      unique tag names
	 *@return           The HTML for inclusion in the second form building page.
	 */

	public String getFBHtml(DBMetaData metaData, int num, int thread)
	{


		StringBuffer ret = new StringBuffer();
		Link linkInfo;

		String tableEnd = "</table></center>\n";
		String tableHeader = "<tr align=\"center\"><font size=\"-1\"><th width=\"25%\">Primary</th><th width=\"25%\">Foreign</th><th width=\"12%\">Ignore</th><th width=\"12%\">Full</th></tr>\n";

		String tableStart = "<center><table cellspacing=\"0\" cellpadding=\"0\" border=\"1\">\n";

		int counter = 3;
		String pcolumn;
		String ptable;
		String fcolumn;
		String ftable;
		String fullLink;
		String fieldEnd = "</tr>\n";
		String fieldStart = "<tr align=\"center\">\n";

		if (metaData == null)
		{
			return "No Avaliable Meta Data...";
		}

		Set formLinks = metaData.getLinkList();

		if (formLinks == null)
		{

			return "No Available Links...";
		}

		Iterator iter = formLinks.iterator();


		ret.append(tableStart);
		ret.append(tableHeader);

		while (iter.hasNext())
		{

			linkInfo = (Link) iter.next();

			ptable = linkInfo.getPtable();
			pcolumn = linkInfo.getPcolumn();
			ftable = linkInfo.getFtable();
			fcolumn = linkInfo.getFcolumn();

			if ((ptable.indexOf("label") < 1) && (ftable.indexOf("label") < 1))
			{
				continue;
			}

			if (ptable.indexOf("label") > 0)
			{
				fullLink = "Table:" + ptable + "~Column:" + pcolumn;
			} else
			{
				fullLink = "Table:" + ftable + "~Column:" + fcolumn;
			}

			ret.append(fieldStart);
			ret.append("<td align=\"left\" width=\"25%\" name=\"Label\" value=\"" + fullLink + "\">" + ptable + "." + pcolumn + "</td>\n");
			ret.append("<td align=\"left\" width=\"25%\">" + ftable + "." + fcolumn + "</td>\n");
			ret.append("<td width=\"25%\"><input type=\"radio\" name=\"Label" + "\" value=\"" + fullLink + "~Label:Ignore\" ></td>\n");
			ret.append("<td width=\"25%\"><input type=\"radio\" name=\"Label" + "\" value=\"" + fullLink + "~Label:Full\" CHECKED></td>\n");
			ret.append(fieldEnd);

			counter++;
		}
		ret.append(tableEnd);
		return new String(ret);
	}


	/**
	 *@param  document  The Document object the return Node will be added to
	 *@return           A Node object for inclusion in the Document being built.
	 */

	public Node getFBNode(Document document)
	{


		//String label1 = nameValues.getValue("Label")[0];
		String table1 = nameValues.getValue("Table")[0];
		String field1 = nameValues.getValue("Column")[0];

		Element ret = document.createElement("dataLabel");

		Element table1Element = document.createElement("table");

		Text table1Text = document.createTextNode(table1);

		table1Element.appendChild(table1Text);

		ret.appendChild(table1Element);

		Element field1Element = document.createElement("column");
		Text field1Text = document.createTextNode(field1);
		field1Element.appendChild(field1Text);
		ret.appendChild(field1Element);

		return ret;
	}

}

