/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import javax.servlet.http.HttpServletResponse;

import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldConnection;
import org.mitre.mrald.util.User;


/**
 *@author     Gail Hamilton
 *@created    November 4, 2003
 */

public class SetLabel extends AbstractStep
{

	/**
	 *  Constructor for the AllTablesListTag object
	 */
	public SetLabel() { }

	 public void execute(MsgObject msg) throws WorkflowStepException
	 {
		 try
		 {

			ArrayList parsedObjects = msg.getWorkingObjects();
		        String update = null;
			User user = (User) msg.getReq().getSession().getAttribute(Config.getProperty("cookietag"));

			for (int i=0; i < parsedObjects.size(); i++)
			{
				LabelElement newElement = (LabelElement)parsedObjects.get(i);
				update = newElement.getUpdateStmnt();
				update = update +  " AND owner = '" + user.getEmail() + "'" ;

				setLabels(update);

			}



			  HttpServletResponse res = msg.getRes();
//			  HttpServletRequest req = (HttpServletRequest) msg.getReq();
			  res.sendRedirect(Config.getProperty("BaseUrl") + "/success.jsp");


		         return;
		 }
		 catch( Exception e)
		 {
	             throw new WorkflowStepException( e) ;
		 }

	 }

	 public void setLabels(String updateStatement) throws WorkflowStepException
	 {
if(true) throw new RuntimeException(" this workflow step must be updated to reflect which datasource is to be used");
        try
		{
		    Connection conn = new MraldConnection().getConnection();
                    Statement stmt = conn.createStatement();

		    stmt.executeUpdate(updateStatement);
		    stmt.close();
		    conn.close();
		}
		catch( SQLException e)
		{
			WorkflowStepException we = new WorkflowStepException(e.getMessage());
			throw we;
		}
	 }
}

