/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.mitre.lattice.util;

/**
 *  Class to contain databse specific template strings
 *
 * @author     Gail Hamilton
 * @created    Feb. 18th, 2004
 */
public class SqlTemplates
{

    private static String ORA_Insert_Trigger = "CREATE TRIGGER <tableName>_Label_Insert AFTER INSERT ON <tableName> FOR EACH ROW BEGIN " +
	                                       " INSERT INTO <tableName>_Label VALUES(<insertTriggerPk> 'NOT SET'); END;";

    private static String ORA_Delete_Trigger = "CREATE TRIGGER <tableName>_Label_Delete AFTER DELETE ON <tableName> FOR EACH ROW " +
		                    " BEGIN DELETE FROM <tableName>_Label WHERE <deleteTriggerPks>; END;";

    private static String POSTGRES_Insert_Trigger =  "CREATE RULE <tableName>_Label_Insert AS ON INSERT TO <tableName> DO " +
	                            " INSERT INTO <tableName>_Label VALUES(<insertTriggerPk> 'NOT SET') ";

    private static String POSTGRES_Delete_Trigger =  "CREATE RULE <tableName>_Label_Delete AS ON DELETE TO <tableName> DO " +
		                    " DELETE FROM <tableName>_Label WHERE <deleteTriggerPks>";

    /**
     *  Description of the Method
     *
     *@param  nowSet  The new isSet value
     */
    public static String getInsertTrigger(String database)
    {
	    if (database.startsWith("Oracle"))
		    return ORA_Insert_Trigger;
	    else if (database.startsWith("PostgreSQL"))
		    return POSTGRES_Insert_Trigger;

	    return ORA_Insert_Trigger;
    }

     /*  Description of the Method
     *
     *@param  nowSet  The new isSet value
     */
    public static String getDeleteTrigger(String database)
    {
	     if (database.startsWith("Oracle"))
		    return ORA_Delete_Trigger;
	    else if (database.startsWith("PostgreSQL"))
		    return POSTGRES_Delete_Trigger;

	    return ORA_Delete_Trigger;
    }

}
