/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */package org.mitre.mrald.query;

import java.net.MalformedURLException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.SAXException;
import java.util.*;


/**
 * This class uses the SAX parser to parse a simple XML file representing possible other MRALD instances to send a
 * query to. The expanded results from the <code>results=texts,subjects</code> is handled<br/
 * > Example of xml file to be parsed:<pre><?xml version="1.0" encoding="utf-8"?> <remote_targets>
 *  <broadcast_target name="Local Admin" local_datasource="db_admin.props" url="http://127.0.0.1:8080/mrald" remote_datasource="db_admin.props" />
 *  <broadcast_target name="Local Baseball" local_datasource="db_basebal.props" url="http://127.0.0.1:8080/mrald" remote_datasource="db_baseball.props" />
 *  </remote_targets></pre>Example usage: <code>//import org.xml.sax.  org.xml.sax.helpers.  java.io. //create
 * input stream to xml source document // Create SAX 2 parser... XMLReader xr = XMLReaderFactory.createXMLReader(); //
 * Set the ContentHandler... BroadcastQueryTargetsParser parser = new BroadcastQueryTargetsParser();
 * xr.setContentHandler(parser); // Parse the file... xr.parse(new InputSource(in_stream)); in_stream.close(); return
 * parser.getBroadcastQueryTargets();</code>
 *
 * @author jchoyt
 */
public class BroadcastQueryTargetsParser extends DefaultHandler
{
    /** The current query target to be populated */
    private BroadcastQueryTarget target;

    /** A List of targets that has been processed so far */
    private List<BroadcastQueryTarget> targets = new ArrayList<BroadcastQueryTarget>(  );

    /** Buffer for collecting data from the "characters" SAX event. */
//    private CharArrayWriter contents = new CharArrayWriter(  );

    /**
     * Override methods of the DefaultHandler class to gain notification of SAX Events. See
     * org.xml.sax.ContentHandler for all available events.
     *
     * @param namespaceURI the Namespace URI, or the empty string if the element has no Namespace URI or if Namespace
     *        processing is not being performed
     * @param localName the local name (without prefix), or the empty string if Namespace processing is not being
     *        performed
     * @param qName the qualified name (with prefix), or the empty string if qualified names are not available
     * @param attr the attributes attached to the element. If there are no attributes, it shall be an empty Attributes
     *        object. The value of this object after startElement returns is undefined
     *
     * @exception SAXException any SAX exception, possibly wrapping another exception
     */
    public void startElement( String namespaceURI, String localName, String qName, Attributes attr ) throws SAXException
    {
        if ( localName.equals( "broadcast_target" ) )
        {
            target = new BroadcastQueryTarget(  );
            targets.add( target );
            target.setName( attr.getValue( "name" ) );
            target.setLocalDatasource( attr.getValue( "local_datasource" ) );

            try
            {
                target.setUrl( attr.getValue( "url" ) );
            }
            catch ( MalformedURLException e )
            {
                throw new SAXException( e );
            }

            target.setRemoteDatasource( attr.getValue( "remote_datasource" ) );
        }
    }

    /**
     * Description of the Method
     *
     * @param namespaceURI Description of Parameter
     * @param localName Description of Parameter
     * @param qName Description of Parameter
     *
     * @exception SAXException Description of Exception
     */
    public void endElement( String namespaceURI, String localName, String qName ) throws SAXException
    {
        //don't need to do anything - this is a very easy strucutre
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public List<BroadcastQueryTarget> getBroadcastQueryTargets(  )
    {
        return targets;
    }
}

