/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package test.org.mitre.lattice.lattice;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.mitre.lattice.graph.SampleLattices;
import org.mitre.lattice.lattice.LatticeTree;
import org.mitre.lattice.lattice.LatticeUserGroup;
import org.mitre.mrald.util.Config;

/**
 *  Description of the Class
 *
 *@author     ghamilton
 *@created    Nov 14, 2003
 */
public class LatticeUserGroupTest extends TestCase
{

    private LatticeTree tree = null;
//    private LatticeUserGroup userGroup = null;
    /**
     *  The main program for the LatticeNodeTest class
     *
     *@param  args  The command line arguments
     */
    public static void main( String[] args )
    {
        junit.textui.TestRunner.run( suite() );
    }


    /**
     *  A unit test suite for JUnit
     *
     *@return    The test suite
     */
    public static Test suite()
    {
        /*
         *  the dynamic way
         */
        return new TestSuite( LatticeUserGroupTest.class );
    }



    /**
     *  Description of the Method
     */
    public void resetNodes()
    {
        setUp();
    }


    /**
     *  test that getting the Most Dominant group works
     */
    public void testGetMostDominant()
    {

     	/*LatticeNode root =*/ tree.getRootNode();
	//userGroup.setUserGroups( new String[]{"topRightPoint", "bottomRightPoint"});

 	//String dominantGroup = userGroup.getMostDominant(root,new String[]{"topRightPoint", "bottomRightPoint"} );
     	//assertEquals( "Most Dominant Group should be ", "topRightPoint" , dominantGroup );

    }

    /**
     *  The JUnit setup method
     */
    protected void setUp()
    {
        Config.setProperty("LOGPATH", "/devel/gail/webapps/digilib/webapps/ROOT/mrald.log");
        Config.setProperty("mraldLogLevel", "2");
        Config.setLatticeFactory( new org.mitre.mrald.util.LatticeFactory() );
        tree = SampleLattices.buildVeryVeryComplexDiamondLattice();
	/*userGroup =*/ new LatticeUserGroup("gail");
   }


    /**
     *  The JUnit teardown method
     */
    protected void tearDown()
    {
    }
}


