/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb;

import java.util.*;


/**
 * A Javabean to act as the "shopping cart" of images for either download or atlasing
 *
 * @author Jeffrey Hoyt
 *
 * @deprecated July 30, 2008
 */
public class ImageCart
{
    /** Item property. */
    protected Set<String> images = new TreeSet<String>(  );

    /**
     * Get image property.
     *
     * @return Item property.
     */
    public Object[] getImages(  )
    {
        return images.toArray(  );
    }


    /**
     * Adds an image to the cart
     *
     * @param image New image property.
     */
    public void addImage( String image )
    {
        images.add( image );
    }

    /**
     * Remove an image to the cart
     *
     * @param image New image property.
     */
    public void removeImage( String image )
    {
        images.remove( image );
    }


    /**
     * Remove an image to the cart
     *
     * @param image New image property.
     */
    public void removeAll( )
    {
        images.clear();
    }


    public int size()
    {
        return images.size();
    }

}

