/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb.taglib;

import org.mitre.mrald.taglib.MraldSpecTag;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

import java.io.*;

import java.sql.*;

import java.util.StringTokenizer;

import javax.servlet.jsp.JspException;


/**
 * Description of the Class
 *
 * @author ghamilton
 *
 * @deprecated September 6, 2007
 */
public class BrowseVolumesListTag extends MraldSpecTag
{
    /**
     * DOCUMENT ME!
     */
    public final static String ORDER_BY_GENDER = " ORDER BY gender,handedness, pi_name, subject_id";

    /**
     * DOCUMENT ME!
     */
    public final static String ORDER_BY_PI = " ORDER BY pi_name, gender, handedness, subject_id";

    /**
     * DOCUMENT ME!
     */
    public final static String ORDER_BY_SUBJECT_AGE = " ORDER BY birthdate, pi_name ,gender,subject_id";

    /**
     * DOCUMENT ME!
     */
    public final static String ORDER_BY_MODALITY = " ORDER BY modality, pi_name, gender, subject_id";

    /** Colors for the headings - the first color is the top heading */
    public final static String[] colors = { "blue", "green", "brown", "black", "red" };

    /**
     * DOCUMENT ME!
     */
    private static String SPACER = "<img alt=\"\" src=\"images/spacer.gif\" width=\"<:width:>\" height=\"1\"/>";

    /**
     * DOCUMENT ME!
     */
    String filter;

    /**
     * DOCUMENT ME!
     */
    String orderBy;

    /**
     * DOCUMENT ME!
     */
    String headingStr = "";

    /**
     * DOCUMENT ME!
     */
    private boolean firstQuery = true;

    /**
     * DOCUMENT ME!
     */
    private boolean lastLevelPrinted = false;

    /**
     *  Constructor for the AddictivesBoxTag object
     */
    public BrowseVolumesListTag(  )
    {
        super(  );
    }

    /**
     * Sets the filter attribute of the NeuronListTag object
     *
     * @param filter The new filter value
     */
    public void setFilter( String filter )
    {
        if ( ( filter == null ) || filter.equals( "" ) )
        {
            filter = "and 1=1";
            this.filter = filter;

            return;
        }

        this.filter = filter;
    }


    /**
     * Sets the filter attribute of the NeuronListTag object
     *
     * @param thisHeading The new headingStr value
     */
    public void setHeadingStr( String thisHeading )
    {
        this.headingStr = thisHeading;
    }


    /**
     * Sets the filter attribute of the NeuronListTag object
     *
     * @param orderBy The new orderBy value
     */
    public void setOrderBy( String orderBy )
    {
        if ( ( orderBy == null ) || orderBy.equals( "" ) )
        {
            orderBy = "";

            return;
        }

        this.orderBy = orderBy;
    }


    /**
     * Gets the query attribute of the BrowseListTag object
     *
     * @return The query value
     */
    protected String[] getQuery(  )
    {
        String groupBy = "";
        String subquery = "";

        String bigSegments=null;

        if ( orderBy == ORDER_BY_GENDER )
        { //the order by gender should also incorporate the handedness
            bigSegments = "SELECT DISTINCT  subject_id, pi_name, gender, handedness " +
                "From subject, project where project.project_id = subject.project_id and subject.subject_oid in (select subject_oid from scan_event) " +
                filter + ORDER_BY_GENDER;
        }
        else if ( orderBy == ORDER_BY_SUBJECT_AGE )
        {
            bigSegments = "SELECT DISTINCT  subject_id, pi_name, gender, birthdate " +
                "From subject, project where  project.project_id = subject.project_id and subject.subject_oid in (select subject_oid from scan_event) " +
                filter + ORDER_BY_SUBJECT_AGE;
        }
        else if ( orderBy == ORDER_BY_PI )
        {
            bigSegments = "SELECT DISTINCT  subject_id, pi_name, handedness, gender " +
                "From subject, project where  project.project_id = subject.project_id and subject.subject_oid in (select subject_oid from scan_event) " +
                filter + ORDER_BY_PI;
        }
        else if ( orderBy == ORDER_BY_MODALITY )
        {
            bigSegments = "SELECT DISTINCT  modality, subject_id, pi_name, gender " +
                "From subject, project,scan_event, volume where project.project_id = subject.project_id " +
                "and subject.subject_oid=scan_event.subject_oid and scan_event.scan_id=volume.scan_id and subject.subject_oid in (select subject_oid from scan_event) "+
                filter + ORDER_BY_MODALITY;
        }
        else
        {
            throw new RuntimeException( "No version specified" );
        }

        return new String[] { bigSegments };
    }


    /**
     * Description of the Method
     *
     * @return Description of the Return Value
     */
    protected String init(  )
    {
        firstQuery = true;

        return "";
    }


    /**
     * Description of the Method
     *
     * @return Description of the Return Value
     */
    protected String endOutput(  )
    {
        try
        {
            pageContext.getOut(  ).flush(  );
        }
        catch ( IOException e )
        {
            // TODO Auto-generated catch block
            e.printStackTrace(  );
        }

        return "";
    }


    /**
     * should only be called from processQuery() in parent class
     *
     * @param rs Description of the Parameter
     *
     * @return Description of the Return Value
     *
     * @exception MraldException Description of the Exception
     */
    protected String processResultSet( ResultSet rs ) throws MraldException
    {
        try
        {
            StringBuffer ret = new StringBuffer(  );
            ResultSetMetaData rsmd = rs.getMetaData(  );
            String[] orderByStr = getOrderByStrings(  );
            String rowsStr = processRows( rs, orderByStr );

            ret.append( rowsStr );

            return ret.toString(  );
        }
        catch ( SQLException e )
        {
            MraldOutFile.logToFile( Config.getProperty( "LOGFILE" ), "BrowseListTag: SQLException:  " +
                e.getMessage(  ) );

            throw new MraldException( e );
        }
    }


    /**
     * Gets the orderByStrings attribute of the BrowseListTag object
     *
     * @return The orderByStrings value
     */
    private String[] getOrderByStrings(  )
    {
        int length = " ORDER BY ".length(  );
        String parseStr = orderBy.substring( length );
        String[] orderByStrings = parseStr.split( "," );

        for ( int i = 0; i < orderByStrings.length; i++ )
        {
            orderByStrings[i] = orderByStrings[i].replaceAll( "\"", "" );
            orderByStrings[i] = orderByStrings[i].trim(  );
        }

        return orderByStrings;
    }


    /**
     * Description of the Method
     *
     * @param rs Description of the Parameter
     * @param orderByStrings Description of the Parameter
     *
     * @return Description of the Return Value
     *
     * @exception SQLException Description of the Exception
     */
    private String processRows( ResultSet rs, String[] orderByStrings )
        throws SQLException
    {

        if ( !firstQuery )
        {
            try
            {
                pageContext.getOut(  ).print( "<a name=\"Other\"></a><h2>Others</h2>" );
                pageContext.getOut(  ).flush(  );
                firstQuery = true;
            }
            catch ( IOException e )
            {
                throw new RuntimeException( e );
            }
        }
        else
        {
            firstQuery = false;
        }

        int count = 0;

        //The last Group for each level
        int noOfLevels = orderByStrings.length;

        // if ( orderBy == ORDER_BY_GENDER )
        // {
        //     noOfLevels = noOfLevels - 1;
        // }

        String[] lastGroup = new String[noOfLevels];
        String[] currentGroup = new String[noOfLevels];

        for ( int j = 0; j < noOfLevels; j++ )
        {
            lastGroup[j] = "";
            currentGroup[j] = "";
        }

        int levelNo = 0;

        while ( rs.next(  ) )
        {
            count++;

            //OrderBY contains a list of columns to be ordered by
            //Get the new list
            for ( int j = 0; j < noOfLevels; j++ )
            {
                String ordering = orderByStrings[j].toString(  );

                //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag: process Rows:  ordering " + ordering    );
                currentGroup[j] = rs.getString( ordering );

                //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag: process Rows:  got value " + currentGroup[j]    );
            }

            //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag: process Rows: no Of levels " + noOfLevels    );
            int currLevel = 0;

            levelNo = 0;

            //INcrement across the list from first ordering to last. AS soon as a difference is detected, set the level
            while ( ( currLevel < noOfLevels ) && ( lastGroup[currLevel].equals( currentGroup[currLevel] ) ) )
            {
                levelNo = currLevel;
                currLevel++;
            }

            if ( currLevel >= noOfLevels )
            {
                lastLevelPrinted = true; //all levels werer the same, we the header should have already been printed
                currLevel = ( noOfLevels - 1 );
            }
            else
            {
                lastLevelPrinted = false; //not all the groupings were the same -need to print the bottommost printer
            }

            //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag: process Rows: about to write for value " +rs.getString( "Subject" )     );
            String rowStr = writeRow( rs, orderByStrings, currLevel );

            //Reset the arrays;
            for ( int i = 0; i < noOfLevels; i++ )
            {
                if ( currentGroup[i] != null && !currentGroup[i].equals("null") )
                {
                    lastGroup[i] = currentGroup[i].toString(  );
                }
                else
                {
                    lastGroup[i] = "Unknown";
                }
            }

            try
            {
                pageContext.getOut(  ).print( rowStr );

                pageContext.getOut(  ).print( "<br />" );
                pageContext.getOut(  ).print( Config.NEWLINE );
                pageContext.getOut(  ).flush(  );
            }
            catch ( IOException e )
            {
                MraldOutFile.logToFile( Config.getProperty( "LOGFILE" ),
                    "BrowseListTag:IOException :  " + e.getMessage(  ) );

                throw new RuntimeException( e );
            }

            //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag:End Loop for i :  " + count    );
        }

        //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseVolumesListTag:End Process Rows.");

        return Config.EMPTY_STR;
    }


    /**
     * Description of the Method
     *
     * @param rs Description of the Parameter
     * @param orderBy Description of the Parameter
     * @param currLevel Description of the Parameter
     *
     * @return Description of the Return Value
     *
     * @exception SQLException Description of the Exception
     */
    private String writeRow( ResultSet rs, String[] orderBy, int currLevel )
        throws SQLException
    {
        StringBuffer ret = new StringBuffer(  );
        int lastLevel = 3;

        // ret.append( lastLevelPrinted + "|" + currLevel);

        //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag: process Rows: about to write Row "      );
        if ( currLevel == lastLevel )
        { //3
          //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag: process Rows: about to write Row level 3 "      );

            if ( !lastLevelPrinted )
            {
                String heading = rs.getString( orderBy[lastLevel] );

                if ( heading == null )
                {
                    heading = "Unknown";
                }

                //ret.append( writeHeading( lastLevel, heading ) );
            }

            ret.append( writeValue( rs, currLevel ) );
        }
        else if ( currLevel == ( lastLevel - 1 ) )
        { //2
          //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag: process Rows: about to write Row level 2 "      );
            String heading = rs.getString( orderBy[currLevel] );

            if ( heading == null )
            {
                heading = "Unknown";
            }

            ret.append( writeHeading( currLevel, heading ) );

            if ( !lastLevelPrinted )
            {
                heading = rs.getString( orderBy[lastLevel] );

                // ret.append( writeHeading( lastLevel, heading ) );
            }

            ret.append( writeValue( rs, lastLevel ) );
        }
        else if ( currLevel == ( lastLevel - 2 ) )
        { //1

            //MraldOutFile.logToFile(Config.getProperty("LOGFILE"), "BrowseListTag: process Rows: about to write Row level 1 "      );
            String heading = rs.getString( orderBy[currLevel] ); //1

            if ( heading == null )
            {
                heading = "Unknown"; //This one
            }

            ret.append( writeHeading( currLevel, heading ) );

            heading = rs.getString( orderBy[currLevel + 1] ); //2

            if ( heading == null )
            {
                heading = "Unknown";
            }

            ret.append( writeHeading( currLevel + 1, heading ) );

            if ( !lastLevelPrinted )
            {
                heading = rs.getString( orderBy[lastLevel] );

                if ( heading == null )
                {
                    heading = "Unknown";
                }

                //ret.append( writeHeading( lastLevel, heading ) );
            }

            ret.append( writeValue( rs, lastLevel ) );
        }
        else if ( currLevel == ( lastLevel - 3 ) )
        { //0
            String heading = rs.getString( orderBy[currLevel] ); //0

            if ( heading == null )
            {
                heading = "Unknown";
            }

            ret.append( writeHeading( currLevel, heading ) );

            heading = rs.getString( orderBy[currLevel + 1] ); //1

            if ( heading == null )
            {
                heading = "Unknown";
            }

            ret.append( writeHeading( currLevel + 1, heading ) );

            heading = rs.getString( orderBy[currLevel + 2] ); //2

            if ( heading == null )
            {
                heading = "Unknown";
            }

            ret.append( writeHeading( currLevel + 2, heading ) );

            heading = rs.getString( orderBy[lastLevel] ); //2

            if ( heading == null )
            {
                heading = "Unknown";
            }

            //ret.append( writeHeading( lastLevel, heading ) );
            ret.append( writeValue( rs, lastLevel ) ); //3
        }

        return ret.toString(  );
    }


    /**
     * Description of the Method
     *
     * @param rs Description of the Parameter
     * @param levelNo Description of the Parameter
     *
     * @return Description of the Return Value
     *
     * @exception SQLException Description of the Exception
     */
    private String writeValue( ResultSet rs, int levelNo )
        throws SQLException
    {
        String width = new String( ( levelNo * 25 ) + "" );
        StringBuffer ret = new StringBuffer(  );

        ret.append( SPACER.replaceAll( "<:width:>", width ) + toLink( rs.getString( "subject_id" ) ) );

        return ret.toString(  );
    }


    /**
     * Description of the Method
     *
     * @param levelNo Description of the Parameter
     * @param heading Description of the Parameter
     *
     * @return Description of the Return Value
     */
    private String writeHeading( int levelNo, String heading )
    {
        String width = new String( ( levelNo * 25 ) + "" );
        StringBuffer ret = new StringBuffer(  );

        if ( levelNo == 0 )
        {
            ret.append( "<a name=\"" + heading + "\"></a><h2 style=\"color:" + colors[levelNo] +
                "\"><input type=\"checkbox\" name=\"" + heading +
                "_chkbox\" onclick=\'if(this.checked==true) CheckGroup(\"" + heading + "\"); else ClearGroup(\"" +
                heading + "\")\'></input>" );
            ret.append( SPACER.replaceAll( "<:width:>", width ) + " " + heading + "</h2>" );
            setHeadingStr( heading );
        }
        else
        {
            ret.append( "<h3 style=\"color:" + colors[levelNo] + "\">" + SPACER.replaceAll( "<:width:>", width ) + " " +
                heading + "</h3>" );
        }

        return ret.toString(  );
    }


    /**
     * Description of the Method
     *
     * @param neuronName Description of the Parameter
     *
     * @return Description of the Return Value
     */
    public String toLink( String neuronName )
    {
        //
        StringBuffer ret = new StringBuffer( "<input type=\"checkbox\" name=\"subject_id\" value=\"" );

        ret.append( neuronName );
        ret.append( "\" id=\"" + headingStr + "_chkbox\"" );
        /*
         *  add neuron name as a link to the details
         */
        ret.append( "/> <b><a href=\"subject_info.jsp?subject_id=" );
        ret.append( neuronName );
        ret.append( "\"> " );
        ret.append( neuronName );
        ret.append( "</a></b>" );

        return ret.toString(  );
    }
}

