/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb.taglib;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.mitre.lattice.neuro.taglib.NeuroSpecificTag;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
/**
 *  Description of the Class
 *
 *@author     ksarver
 *@created    Sept 16, 2003
 */
public class SubjectBoxTag extends NeuroSpecificTag
{
	/**
	 *  Constructor for the SubjectBoxTag object
	 */
	public SubjectBoxTag()
	{
		super();
	}

	/**
	 *  Gets the query attribute of the MedicalTestResultTag object
	 *
	 *@return    The query value
	 */
	protected String[] getQuery()
	{

		String subjID =  pageContext.getRequest().getParameter("subject_id");
		if (subjID != null)
			subjID =  MiscUtils.checkApostrophe(subjID);
		String query = "SELECT DISTINCT subject.subject_id,initial_exam, birthdate, nation_of_residence,gender, race, primary_language, second_language, third_language, marital_status, education, handedness, height, weight  FROM subject WHERE subject.subject_id ='" + subjID + "'";

	        return new String[]{query};
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String init()
	{
		StringBuffer ret = new StringBuffer();
		ret.append("<table width='100%' border='0' cellspacing='0' cellpadding='0'>");
		ret.append("<tr>");
		ret.append("<td class='bord'>");
		ret.append("<table width='100%' border='0' cellspacing='1' cellpadding='0'>");
		ret.append("<tr>");
		ret.append("<th>S u b j e c t &nbsp; I n f o</th>");
		ret.append("</tr>");
		ret.append("<tr>");
		ret.append("<td valign='top'>");
		ret.append("<table width='100%' border='0' cellspacing='1' cellpadding='2'>");

		return ret.toString();
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String endOutput()
	{
		StringBuffer ret = new StringBuffer();
		ret.append("</table>");
		ret.append("</td>");
		ret.append("</tr>");
		ret.append("</table>");
		ret.append("</td>");
		ret.append("</tr>");
		ret.append("</table>");
		return ret.toString();
	}


	/**
	 *  Description of the Method
	 *
	 *@param  rs                  Description of the Parameter
	 *@return                     Description of the Return Value
	 *@exception  MraldException  Description of the Exception
	 */
	protected String processResultSet(ResultSet rs) throws MraldException
	{
		try
		{
//			String subjID = pageContext.getRequest().getParameter("subject_id");

			StringBuffer ret = new StringBuffer();

			ResultSetMetaData rsmd = rs.getMetaData();
			int numberOfColumns = rsmd.getColumnCount();

			while (rs.next())
			{
				for (int i = 0; i < numberOfColumns; i++)
				{
					ret.append("<tr>");
					ret.append("<td width='50%' align='Right'>" + rsmd.getColumnLabel(i + 1) + ": </td>");
					ret.append("<td align=left>" + rs.getString(i + 1) + "</td>");
					ret.append("</tr>");
				}
			}

			return ret.toString();
		} catch (SQLException e)
		{
			throw new MraldException(e.getMessage());
		}
	}
}

