/*
 *  Copyright 2008 The MITRE Corporation (http://www.mitre.org/). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mitre.neuroWeb.taglib;
// import ij.ImagePlus;
// import ij.io.FileInfo;
// import ij.io.FileOpener;
// import ij.plugin.JpegWrapper;

import java.io.File;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.mitre.lattice.neuro.taglib.NeuroSpecificTag;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;
import org.mitre.mrald.util.User;
import org.mitre.image_viewer.*;
/**
 *  Description of the Class
 *
 *@author     ghamilton
 *@created    September 20, 2007
 */
public class SubjectVolumeListTag extends NeuroSpecificTag
{

	String subjectId ="";
	/**
	 *  Constructor for the MedicalHistoryResultTag object
	 */
	public SubjectVolumeListTag()
	{
		super();
	}


	/**
	 *  Gets the query attribute of the MedicalTestResultTag object
	 *
	 *@return    The query value
	 */
	protected String[] getQuery()
	{


		String query = null;

		if (subjectId != null)
		{
			subjectId =  MiscUtils.checkApostrophe(subjectId);

		     query = "SELECT DISTINCT subject.subject_id, gender, scan_date, birthdate, handedness, " +
		     		" modality, xdimension, ydimension, zdimension, " +
		     		" volume.volume_id, images.filename, numerical_format, endianness  FROM subject, scan_event, volume, images " +
					" WHERE subject.subject_id = '" + subjectId + "'" +
					" AND volume.volume_id = images.volume_id " +
					" AND scan_event.subject_oid = subject.subject_oid " +
					" AND volume.scan_id = scan_event.scan_id ";
		}

		return new String[]{query};
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String init()
	{
		StringBuffer ret = new StringBuffer();

		ret.append("<table width='100%' border='0' cellspacing='1' cellpadding='2'>");
		ret.append("<tr>");
		ret.append("<th colspan=\"4\">S u b j e c t  &nbsp; R e s u l t s</th>");
		ret.append("</tr>");

		return ret.toString();
	}


	/**
	 *  Description of the Method
	 *
	 *@return    Description of the Return Value
	 */
	protected String endOutput()
	{
		StringBuffer ret = new StringBuffer();

		ret.append("</table>");
		return ret.toString();
	}


	public void setSubjectId(String thisSubjectId)
	{
		subjectId = thisSubjectId;
	}
	/**
	 *  Description of the Method
	 *
	 *@param  rs                  Description of the Parameter
	 *@return                     Description of the Return Value
	 *@exception  MraldException  Description of the Exception
	 */
	protected String processResultSet(ResultSet rs) throws MraldException
	{
		try
		{

			User mraldUser = (User)pageContext.getSession().getAttribute(Config.getProperty("cookietag"));

			String style_normal="background:#4088b8;color:#c8c8c8;";

			String objectType = "Subject";
			if (subjectId == null)  objectType = "Scan";

			StringBuffer ret = new StringBuffer();
            StringBuffer retStart = new StringBuffer();

            ret.append( "\n<table border='0' cellspacing='1' cellpadding='2'>" );

			ResultSetMetaData rsmd = rs.getMetaData();
			int numberOfColumns = rsmd.getColumnCount();

			while (rs.next())
			{
				boolean littleEndianness = true;

				String fileName = rs.getString("filename");

				String volumeId = rs.getString("volume_id");
				int xdim = rs.getInt("xdimension");
				int ydim = rs.getInt("ydimension");
				int zdim = rs.getInt("zdimension");
				// String numericalFormatcd  = rs.getString("numerical_format");
				// String endian = rs.getString("endianness");

				// if (endian == null)
				// 	littleEndianness = true;
				// else
				// {
				// 	if (endian.toLowerCase().equals("little"))
				// 		littleEndianness = true;
				// 	else
				// 		littleEndianness = false;
				// }

				// String[] imgNames = createSampleSlice(Config.getProperty( "imagesDir" ) + Config.FILE_SEPARATOR + fileName, xdim, ydim, zdim, numericalFormat, littleEndianness);

				boolean firstTime = true;
				// if (imgNames != null)
				// {
				// 	for (String imagName: imgNames)
				// 	{
				// 		if (firstTime)
				// 		{
				// 			ret.append("<tr><td colspan=\"4\"><table><tr><td align=\"left\"><img src=\"");
				// 			firstTime = false;
				// 		}
				// 		else
				// 			ret.append("<td><img src=\"");

				// 		ret.append(imagName + "\"/></td>");
				// 	}
				// 	ret.append("</tr></table></td></tr>");
				// }

				String email="";
				String fromEmail=mraldUser.getEmail();
				String emailParams = "?emailAddr=" + email + "&DataSet=" + fileName + "&sendFrom=" + fromEmail + "&comments=";

				// if (imgNames != null)
				// {
				// 	ret.append("\n<tr><td><table>");
				// 	ret.append("\n<tr><td><form action=\"viewImage.jsp?imageFile=" + fileName + "\" size=\"20\" method=\"POST\"><input type=\"submit\" value=\"     Viewer          \" style=\""+ style_normal + "\"></input></form></td>");
				// 	ret.append("<td><form action=\"volume_info.jsp?volume_id=" + volumeId + "&subject_id=" + subjectId + "\" size=\"20\" method=\"POST\"><input type=\"submit\" value=\"    More Details    \" style=\""+ style_normal + "\"></input></form></td>");
				// 	ret.append("<td><form action=\"ImageServer.jsp\"><input type=\"hidden\" name=\"fileName\" value=\"" +
		        //          fileName + "\"></input><input name=\"fileAction\" type=\"submit\" value=\"download\" style=\""+ style_normal + "\"></form></td>");
				// 	//ret.append("<td><form action=\"sendEmail.jsp\" size=\"20\" method=\"POST\"><input type=\"submit\" value=\"    Download        \" style=\""+ style_normal + "\"></input></form></td>");
				// 	ret.append("<td><form action=\"emailForm.jsp" +emailParams + "\" size=\"20\" method=\"POST\"><input type=\"submit\" value=\"Request Original\" style=\""+ style_normal + "\"></input></form></td></tr>");
				// 	ret.append("\n</table></td></tr>");

                // }
				ret.append("\n<table>");
				for (int i = 0; i < numberOfColumns; i++)
				{
					if (rsmd.getColumnLabel(i + 1).equals("numerical_format"))
						continue;

					ret.append("\n<tr>");
					ret.append("<td width='33%' align='Right'>" + rsmd.getColumnLabel(i + 1) + ": </td>");
					ret.append("<td align=left>" + rs.getString(i + 1) + "</td>");
					ret.append("</tr>");

				}

				ret.append("<tr><th colspan=\"4\"></th></tr>");
				ret.append("</table></td></tr>");
			}

			ret.append("</table>");
			return retStart.toString() + ret.toString();
		} catch (SQLException e)
		{
			throw new MraldException(e.getMessage());
		}

	}

// 	public static String[] createSampleSlice(String imageName, int xdim, int ydim, int zdim, String numerical_format, boolean endianness) throws MraldException
// 	{

// 		try
// 		{
// 			File sourceImage = new File(imageName);

// 			if (!sourceImage.exists()) return null;

// 			String temp="";
// 			if (sourceImage.toString().lastIndexOf('.') >= 0)
// 				temp = sourceImage.toString().substring(0, sourceImage.toString().lastIndexOf('.') ) ;

// 			String destination1 =  temp + "_sag" + ".jpg";
// 			String destination2 = temp  + "_ax" + ".jpg";
// 			String destination3 =  temp + "_cor" + ".jpg";


// 			String pathDir = Config.getProperty("BasePath");
// 			pathDir = pathDir.replaceAll(Config.FILE_SEPARATOR + Config.FILE_SEPARATOR, Config.FILE_SEPARATOR);

// 			int noOfImages = 3;

// 			// If this is not a volume, ie. has no zdim then only create one image
// 			if (zdim == 1)
// 				noOfImages = 1;

// 			String[] images = new String[noOfImages];
// 			images[0] = destination1.replaceAll(pathDir, "");

// 			if (images[0].startsWith(Config.FILE_SEPARATOR))
// 			{
// 				images[0] = images[0].substring(1, images[0].length());
// 			}

// 			if (noOfImages > 1)
// 			{
// 				images[1] = destination2.replaceAll(pathDir, "");
// 				if (images[1].startsWith(Config.FILE_SEPARATOR))
// 				{
// 					images[1] = images[1].substring(1, images[1].length());
// 				}
// 				images[2] = destination3.replaceAll(pathDir, "");
// 				if (images[2].startsWith(Config.FILE_SEPARATOR))
// 				{
// 					images[2] = images[2].substring(1, images[2].length());
// 				}
// 			}

// //			Test to see if the image exist. If they do skip this
// 			if (new File(destination1).exists())
// 				return images;


// 			//if (new File(destination).exists())
// 			//{
// 			//	return imageFileName;
// 			//}

// 			int fileType = 0;
// 			if (numerical_format.equals("16 bit unsigned"))
// 			{
// 				fileType = FileInfo.GRAY16_UNSIGNED;
// 			}
// 			else if (numerical_format.equals("16 bit signed"))
// 			{
// 				fileType = FileInfo.GRAY16_SIGNED;
// 			}
// 			else if (numerical_format.equals("8 bit signed"))
// 			{
// 				fileType = FileInfo.GRAY8;
// 			}
// 			else
// 				fileType = FileInfo.GRAY16_UNSIGNED;

// 			FileInfo fi = createFileOpener(sourceImage, fileType, xdim,ydim,zdim, endianness);
// 			ImagePlus result = new FileOpener(fi).open(false);

// 			result.setSlice(fi.nImages / 2);

// 			//(new FileSaver(result)).saveAsJpeg(destination);

// 			(new JpegWrapper()).save(result, destination1);
// 			//MraldOutFile.logToFile( "VolumeDetailTag : createSampleSlice: destination " + destination  );

// 			//MraldOutFile.logToFile( "VolumeDetailTag : createSampleSlice " + imageFileName  );

// 			//Only if this is a volume i.e. has multiple slices
// 			if (fi.nImages > 1)
// 			{

// 				//Coronal Image
// 				int inOrientation=SlicePanel.AXIAL_RIGHT;
// 				int outOrientation = SlicePanel.CORONAL_RIGHT;

// 				ImagePlus corImg = SlicePanel.ImageConvertToCoronal( result,  inOrientation, outOrientation,  xdim, ydim, zdim );
// 				corImg.setSlice(fi.nImages / 2);
// 			    (new JpegWrapper()).save(corImg, destination2);

// //			  Sagittal Image
// 			    //File newCorFile = new File(imageName);
// 				//FileInfo fiCorNew = createFileOpener(newCorFile, fileType, xdim,ydim,zdim);

// 			    inOrientation=SlicePanel.AXIAL_RIGHT;
// 				outOrientation = SlicePanel.SAGITAL_RIGHT;
// 				//newImage = new FileOpener(fiCorNew).open(false);

// 				ImagePlus sagImg = SlicePanel.ImageConvertToSagital( result,  inOrientation, outOrientation,  xdim, ydim, zdim );
// 				//In sagittal image the no of slices is y dimension in axial orientation
// 				sagImg.setSlice(ydim / 2);
// 				(new JpegWrapper()).save(sagImg, destination3);

// 			}
// 			return images;
// 		}
// 		catch(Exception e)
// 		{
// 			throw new MraldException(e);
// 		}
// 	}

	// private static FileInfo createFileOpener(File sourceImage, int fileType, int xdim, int ydim,  int zdim, boolean endianness)
	// {
	// 	FileInfo fi = new FileInfo();
	// 	fi.fileName = sourceImage.getName();
	// 	fi.directory = sourceImage.getParent();
	// 	fi.fileFormat = FileInfo.RAW;
	// 	fi.fileType = fileType;
	// 	fi.width = xdim;
	// 	fi.height = ydim;
	// 	fi.nImages = zdim;
	// 	fi.offset = 0;
	// 	fi.gapBetweenImages = 0;
	// 	fi.intelByteOrder = endianness;
	// 	fi.whiteIsZero = false;
	// 	return fi;
	// }
}

