package pipasoft;

import java.util.logging.Level;
import java.util.logging.Logger;

import java.io.*;
import java.net.*;
import java.util.Vector;


/**
 *  This class does a simple HTTP GET and writes the retrieved content to a
 *  local file<br/>
 *  <br/>
 *  Downloaded from pipasoft.com, which allows its use without restrictions
 *  Heavily modified by Jeffrey Hoyt (jchoyt@mitre.org)
 *
 * @author     Brian Pipa - http: //pipasoft.com
 * @created    April 24, 2006
 * @version    1.0
 */
public class wget
{

    /**
     *  Description of the Field
     */
    public final static String KEY = wget.class.getName();
    /**
     *  Description of the Field
     */
    public final static Logger log = Logger.getLogger( KEY );
    final static String FS = File.separator;
    final static String NEWLINE = System.getProperty("line.separator");
    static
    {
        // log.setLevel( Level.FINER );
    }


    /**
     *  This met hod does the actual GET
     *
     * @param  theUrl           The URL to retrieve
     * @param  filename         the local file to save to
     * @exception  IOException
     */
    public void get( String theUrl, String filename )
        throws IOException
    {
        try
        {
            URL gotoUrl = new URL( theUrl );
            InputStreamReader isr = new InputStreamReader( gotoUrl.openStream() );
            BufferedReader in = new BufferedReader( isr );
            StringBuffer sb = new StringBuffer();
            String inputLine;
            boolean isFirst = true;
            //grab the contents at the URL
            while ( ( inputLine = in.readLine() ) != null )
            {
                sb.append( inputLine + NEWLINE );
            }
            //write it locally
            createAFile( filename, sb.toString() );
        }
        catch ( MalformedURLException mue )
        {
            mue.printStackTrace();
        }
        catch ( IOException ioe )
        {
            throw ioe;
        }
    }
    //creates a local file

    /**
     *  Description of the Method
     *
     * @param  theUrl           Description of the Parameter
     * @param  filename         Description of the Parameter
     * @exception  IOException  Description of the Exception
     */
    public static void saveImage( String theUrl, String filename )
        throws IOException
    {
        try
        {
            URL gotoUrl = new URL( theUrl );
            InputStream isr = gotoUrl.openStream();
            int bufferSize = 1024 * 4;
            byte[] buffer = new byte[bufferSize];
            String inputLine;
            boolean isFirst = true;
            FileOutputStream fileoutputstream = new FileOutputStream( filename );
            DataOutputStream dataoutputstream = new DataOutputStream( fileoutputstream );
            int count = 0;
            while ( ( count = isr.read( buffer, 0, bufferSize ) ) != -1 )
            {
                log.finer( "Read " + count + " bytes from " + theUrl );
                dataoutputstream.write( buffer, 0, count );
            }
            dataoutputstream.flush();
            dataoutputstream.close();
        }
        catch ( MalformedURLException mue )
        {
            mue.printStackTrace();
        }
        catch ( IOException ioe )
        {
            throw ioe;
        }
    }


    /**
     *  This method does the actual GET and returns the file as a String<br/>
     *  <br/>
     *  added by Jeffrey Hoyt
     *
     * @param  theUrl           The URL to retrieve
     * @return                  Description of the Return Value
     * @exception  IOException
     */
    public static String get( String theUrl )
        throws IOException
    {
        URL gotoUrl = new URL( theUrl );
        StringBuffer sb = new StringBuffer();
        String inputLine;
        boolean isFirst = true;

        try
        {
            InputStreamReader isr = new InputStreamReader( gotoUrl.openStream() );
            BufferedReader in = new BufferedReader( isr );
            //grab the contents at the URL
            while ( ( inputLine = in.readLine() ) != null )
            {
                sb.append( inputLine + System.getProperty( "line.separator" ) );
            }
        }
        catch ( MalformedURLException mue )
        {
            mue.printStackTrace();
        }
        catch ( IOException ioe )
        {
            throw ioe;
        }
        //return it
        return sb.toString();
    }



    /**
     *  Writes a String to a local file
     *
     * @param  outfile          the file to write to
     * @param  content          the contents of the file
     * @exception  IOException
     */
    public static void createAFile( String outfile, String content )
        throws IOException
    {
        FileOutputStream fileoutputstream = new FileOutputStream( outfile );
        DataOutputStream dataoutputstream = new DataOutputStream( fileoutputstream );

        dataoutputstream.writeBytes( content );
        dataoutputstream.flush();
        dataoutputstream.close();
    }


    /**
     *  The main method.
     *
     * @param  args
     */
    public static void main( String[] args )
    {
        if ( args.length != 2 )
        {
            System.out.println( "Usage: java wget URL localfilename" );
            System.out.println( "Example: java wget http://google.com google.html" );
            System.exit( 1 );
        }
        try
        {
            wget httpGetter = new wget();

            httpGetter.get( args[0], args[1] );
        }
        catch ( Exception ex )
        {
            ex.printStackTrace();
        }
    }
}

